/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.Writer;
import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.ByteStringWriter;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.core.Maths;
import org.jetbrains.annotations.NotNull;

public interface ByteStringAppender<B extends ByteStringAppender<B>>
extends StreamingDataOutput<B>,
Appendable {
    default public Writer writer() {
        return new ByteStringWriter(this);
    }

    @NotNull
    default public B append(char ch) throws BufferOverflowException {
        BytesInternal.appendUtf8Char(this, ch);
        return (B)this;
    }

    @NotNull
    default public B append(@NotNull CharSequence cs) throws BufferOverflowException {
        return (B)this.append(cs, 0, cs.length());
    }

    @NotNull
    default public B append(long value) throws BufferOverflowException {
        BytesInternal.append(this, value, 10);
        return (B)this;
    }

    @NotNull
    default public B appendBase(long value, int base) throws BufferOverflowException {
        BytesInternal.append(this, value, base);
        return (B)this;
    }

    @NotNull
    default public B appendDecimal(long value, int decimalPlaces) throws BufferOverflowException {
        BytesInternal.appendDecimal(this, value, decimalPlaces);
        return (B)this;
    }

    @NotNull
    default public B append(float f) throws BufferOverflowException {
        BytesInternal.append(this, f);
        return (B)this;
    }

    @NotNull
    default public B append(double d) throws BufferOverflowException {
        BytesInternal.append(this, d);
        return (B)this;
    }

    @NotNull
    default public B append(double d, int decimalPlaces) throws BufferOverflowException {
        double d2;
        if (decimalPlaces < 20 && (d2 = d * (double)Maths.tens((int)decimalPlaces)) <= 9.223372036854776E18 && d2 >= -9.223372036854776E18) {
            return this.appendDecimal(Math.round(d2), decimalPlaces);
        }
        return this.append(d);
    }

    @NotNull
    default public B append(@NotNull CharSequence cs, int start, int end) throws IndexOutOfBoundsException, BufferOverflowException {
        BytesInternal.appendUtf8(this, cs, start, end - start);
        return (B)this;
    }

    @NotNull
    default public B append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException {
        return this.append8bit(cs, 0, cs.length());
    }

    default public B append8bit(@NotNull String cs) throws BufferOverflowException, BufferUnderflowException {
        return this.append8bit(cs, 0, cs.length());
    }

    default public B append8bit(@NotNull CharSequence cs, int start, int end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        if (cs instanceof BytesStore) {
            return (B)((ByteStringAppender)this.write((BytesStore)cs, (long)start, (long)end));
        }
        for (int i = start; i < end; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte((byte)c);
        }
        return (B)this;
    }

    default public B appendDateMillis(long dateInMillis) {
        BytesInternal.appendDateMillis(this, dateInMillis);
        return (B)this;
    }

    default public B appendTimeMillis(long timeOfDayInMillis) {
        BytesInternal.appendTimeMillis(this, timeOfDayInMillis % 86400000L);
        return (B)this;
    }

    default public B append(BigDecimal bigDecimal) {
        this.append(bigDecimal.toString());
        return (B)this;
    }
}

