/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.ByteableLongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import org.jetbrains.annotations.NotNull;

public class BinaryLongArrayReference
implements ByteableLongArrayValues {
    private static final long CAPACITY = 0L;
    private static final long USED = 8L;
    private static final long VALUES = 16L;
    private static final int MAX_TO_STRING = 128;
    private BytesStore bytes;
    private long offset;
    private long length = 16L;

    public static void write(@NotNull Bytes bytes, long capacity) throws BufferOverflowException, IllegalArgumentException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        long start = bytes.writePosition();
        bytes.zeroOut(start, start + (capacity << 3));
        bytes.writeSkip(capacity << 3);
    }

    public static void lazyWrite(@NotNull Bytes bytes, long capacity) throws BufferOverflowException {
        assert ((bytes.writePosition() & 7L) == 0L);
        bytes.writeLong(capacity);
        bytes.writeLong(0L);
        bytes.writeSkip(capacity << 3);
    }

    public static long peakLength(@NotNull BytesStore bytes, long offset) throws BufferUnderflowException {
        long capacity = bytes.readLong(offset);
        assert (capacity > 0L) : "capacity too small";
        return (capacity << 3) + 16L;
    }

    public long getCapacity() {
        return this.length - 16L >>> 3;
    }

    public long getUsed() {
        return this.bytes.readVolatileLong(this.offset + 8L);
    }

    public void setMaxUsed(long usedAtLeast) {
        this.bytes.writeMaxLong(this.offset + 8L, usedAtLeast);
    }

    public long getValueAt(long index) throws BufferUnderflowException {
        return this.bytes.readLong(16L + this.offset + (index << 3));
    }

    public void setValueAt(long index, long value) throws IllegalArgumentException, BufferOverflowException {
        this.bytes.writeLong(16L + this.offset + (index << 3), value);
    }

    public long getVolatileValueAt(long index) throws BufferUnderflowException {
        return this.bytes.readVolatileLong(16L + this.offset + (index << 3));
    }

    public void bindValueAt(int index, @NotNull LongValue value) {
        ((BinaryLongReference)value).bytesStore(this.bytes, 16L + this.offset + (long)(index << 3), 8L);
    }

    public void setOrderedValueAt(long index, long value) throws IllegalArgumentException, BufferOverflowException {
        this.bytes.writeOrderedLong(16L + this.offset + (index << 3), value);
    }

    public boolean compareAndSet(long index, long expected, long value) throws IllegalArgumentException, BufferOverflowException {
        return this.bytes.compareAndSwapLong(16L + this.offset + (index << 3), expected, value);
    }

    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws BufferUnderflowException, IllegalArgumentException {
        if (length != BinaryLongArrayReference.peakLength(bytes, offset)) {
            throw new IllegalArgumentException(length + " != " + BinaryLongArrayReference.peakLength(bytes, offset));
        }
        this.bytes = bytes;
        this.offset = offset + 7L & 0xFFFFFFFFFFFFFFF8L;
        this.length = length;
    }

    public boolean isNull() {
        return this.bytes == null;
    }

    public void reset() {
        this.bytes = null;
        this.offset = 0L;
        this.length = 0L;
    }

    public BytesStore bytesStore() {
        return this.bytes;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long maxSize() {
        return this.length;
    }

    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "not set";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("value: ");
        String sep = "";
        try {
            long valueAt;
            int i;
            int max = (int)Math.min(this.getCapacity(), 128L);
            for (i = 0; i < max && (valueAt = this.getValueAt(i)) != 0L; ++i) {
                sb.append(sep).append(valueAt);
                sep = ", ";
            }
            if ((long)i < this.getCapacity()) {
                sb.append(" ...");
            }
        }
        catch (BufferUnderflowException e) {
            sb.append(" ").append(e);
        }
        return sb.toString();
    }

    @Override
    public long sizeInBytes(long capacity) {
        return (capacity << 3) + 16L;
    }
}

