/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.util.ObjectUtils;

public class BytesMarshaller<T> {
    public static final ClassLocal<BytesMarshaller> BYTES_MARSHALLER_CL = ClassLocal.withInitial(BytesMarshaller::new);
    private final FieldAccess[] fields;

    public BytesMarshaller(Class<T> tClass) {
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        BytesMarshaller.getAllField(tClass, map);
        this.fields = (FieldAccess[])map.values().stream().map(FieldAccess::create).toArray(FieldAccess[]::new);
    }

    public static void getAllField(Class clazz, Map<String, Field> map) {
        if (clazz != Object.class) {
            BytesMarshaller.getAllField(clazz.getSuperclass(), map);
        }
        for (Field field : clazz.getDeclaredFields()) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            field.setAccessible(true);
            map.put(field.getName(), field);
        }
    }

    public void readMarshallable(ReadBytesMarshallable t, BytesIn in) {
        for (FieldAccess field : this.fields) {
            field.read(t, in);
        }
    }

    public void writeMarshallable(WriteBytesMarshallable t, BytesOut out) {
        for (FieldAccess field : this.fields) {
            field.write(t, out);
        }
    }

    static class DoubleFieldAccess
    extends FieldAccess {
        public DoubleFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            write.writeDouble(this.field.getDouble(o));
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            this.field.setDouble(o, read.readDouble());
        }
    }

    static class LongFieldAccess
    extends FieldAccess {
        public LongFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            write.writeLong(this.field.getLong(o));
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            this.field.setLong(o, read.readLong());
        }
    }

    static class FloatFieldAccess
    extends FieldAccess {
        public FloatFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            write.writeFloat(this.field.getFloat(o));
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            this.field.setFloat(o, read.readFloat());
        }
    }

    static class IntegerFieldAccess
    extends FieldAccess {
        public IntegerFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            write.writeInt(this.field.getInt(o));
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            this.field.setInt(o, read.readInt());
        }
    }

    static class ShortFieldAccess
    extends FieldAccess {
        public ShortFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            write.writeShort(this.field.getShort(o));
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            this.field.setShort(o, read.readShort());
        }
    }

    static class ByteFieldAccess
    extends FieldAccess {
        public ByteFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            write.writeByte(this.field.getByte(o));
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            this.field.setByte(o, read.readByte());
        }
    }

    static class BooleanFieldAccess
    extends FieldAccess {
        public BooleanFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            write.writeBoolean(this.field.getBoolean(o));
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            this.field.setBoolean(o, read.readBoolean());
        }
    }

    static class MapFieldAccess
    extends FieldAccess {
        final Supplier<Map> collectionSupplier;
        private final Class<?> type;
        private final Class keyType;
        private final Class valueType;

        public MapFieldAccess(Field field) {
            super(field);
            this.type = field.getType();
            this.collectionSupplier = this.type == Map.class ? LinkedHashMap::new : (this.type == SortedMap.class || this.type == NavigableMap.class ? TreeMap::new : this.newInstance());
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)genericType;
                Type[] actualTypeArguments = pType.getActualTypeArguments();
                this.keyType = MapFieldAccess.extractClass(actualTypeArguments[0]);
                this.valueType = MapFieldAccess.extractClass(actualTypeArguments[1]);
            } else {
                this.keyType = Object.class;
                this.valueType = Object.class;
            }
        }

        private Supplier<Map> newInstance() {
            try {
                return (Supplier)this.type.newInstance();
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            throw new UnsupportedOperationException("TODO");
        }
    }

    static class CollectionFieldAccess
    extends FieldAccess {
        final Supplier<Collection> collectionSupplier;
        private final Class componentType;
        private final Class<?> type;

        public CollectionFieldAccess(Field field) {
            super(field);
            this.type = field.getType();
            this.collectionSupplier = this.type == List.class || this.type == Collection.class ? ArrayList::new : (this.type == SortedSet.class || this.type == NavigableSet.class ? TreeSet::new : (this.type == Set.class ? LinkedHashSet::new : this.newInstance()));
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)genericType;
                Type type0 = pType.getActualTypeArguments()[0];
                this.componentType = CollectionFieldAccess.extractClass(type0);
            } else {
                this.componentType = Object.class;
            }
        }

        private Supplier<Collection> newInstance() {
            try {
                return (Supplier)this.type.newInstance();
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            throw new UnsupportedOperationException("TODO");
        }
    }

    static class ArrayFieldAccess
    extends FieldAccess {
        private final Class componentType;

        public ArrayFieldAccess(Field field) {
            super(field);
            this.componentType = field.getType().getComponentType();
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            throw new UnsupportedOperationException("TODO");
        }
    }

    static class BytesFieldAccess
    extends FieldAccess<BytesStore> {
        public BytesFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            BytesStore bytes = (BytesStore)this.field.get(o);
            long offset = bytes.readPosition();
            long length = bytes.readRemaining();
            write.writeStopBit(length);
            write.write(bytes, offset, length);
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            long length = read.readStopBit();
            NativeBytesStore<Void> bs = NativeBytesStore.nativeStore(length);
            bs.copyTo((BytesStore)((Object)read));
            read.readSkip(length);
            this.field.set(o, bs);
        }
    }

    static class BytesMarshallableFieldAccess
    extends FieldAccess<Object> {
        public BytesMarshallableFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            BytesMarshallable o2 = (BytesMarshallable)this.field.get(o);
            assert (o2 != null);
            o2.writeMarshallable(write);
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            BytesMarshallable o2 = (BytesMarshallable)this.field.get(o);
            if (!this.field.getType().isInstance(o2)) {
                o2 = (BytesMarshallable)ObjectUtils.newInstance(this.field.getType());
                this.field.set(o, o2);
            }
            o2.readMarshallable(read);
        }
    }

    static class ScalarFieldAccess
    extends FieldAccess<Object> {
        public ScalarFieldAccess(Field field) {
            super(field);
        }

        @Override
        protected void getValue(Object o, BytesOut write) throws IllegalAccessException {
            Object o2 = this.field.get(o);
            String s = o2 == null ? null : o2.toString();
            write.writeUtf8(s);
        }

        @Override
        protected void setValue(Object o, BytesIn read) throws IllegalAccessException {
            String s = read.readUtf8();
            this.field.set(o, ObjectUtils.convertTo(this.field.getType(), (Object)s));
        }
    }

    static abstract class FieldAccess<T> {
        final Field field;

        FieldAccess(Field field) {
            this.field = field;
        }

        public static Object create(Field field) {
            Class<?> type = field.getType();
            switch (type.getName()) {
                case "boolean": {
                    return new BooleanFieldAccess(field);
                }
                case "byte": {
                    return new ByteFieldAccess(field);
                }
                case "short": {
                    return new ShortFieldAccess(field);
                }
                case "int": {
                    return new IntegerFieldAccess(field);
                }
                case "float": {
                    return new FloatFieldAccess(field);
                }
                case "long": {
                    return new LongFieldAccess(field);
                }
                case "double": {
                    return new DoubleFieldAccess(field);
                }
            }
            if (type.isArray()) {
                return new ArrayFieldAccess(field);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return new CollectionFieldAccess(field);
            }
            if (Map.class.isAssignableFrom(type)) {
                return new MapFieldAccess(field);
            }
            if (BytesStore.class.isAssignableFrom(type)) {
                return new BytesFieldAccess(field);
            }
            if (BytesMarshallable.class.isAssignableFrom(type)) {
                return new BytesMarshallableFieldAccess(field);
            }
            return new ScalarFieldAccess(field);
        }

        static Class extractClass(Type type0) {
            if (type0 instanceof Class) {
                return (Class)type0;
            }
            if (type0 instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type0).getRawType();
            }
            return Object.class;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "field=" + this.field + '}';
        }

        void write(Object o, BytesOut write) {
            try {
                this.getValue(o, write);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
        }

        protected abstract void getValue(Object var1, BytesOut var2) throws IllegalAccessException;

        void read(Object o, BytesIn read) {
            try {
                this.setValue(o, read);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
        }

        protected abstract void setValue(Object var1, BytesIn var2) throws IllegalAccessException;
    }
}

