/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;

public class UncheckedBytes<Underlying>
extends AbstractBytes<Underlying> {
    public UncheckedBytes(@NotNull Bytes underlyingBytes) throws IllegalStateException {
        super(underlyingBytes.bytesStore(), underlyingBytes.writePosition(), underlyingBytes.writeLimit());
        this.readPosition(underlyingBytes.readPosition());
    }

    @Override
    @NotNull
    public Bytes<Underlying> unchecked(boolean unchecked) {
        return this;
    }

    @Override
    void writeCheckOffset(long offset, long adding) {
    }

    @Override
    void readCheckOffset(long offset, long adding, boolean given) {
    }

    @Override
    void prewriteCheckOffset(long offset, long subtracting) {
    }

    @Override
    @NotNull
    public Bytes<Underlying> readPosition(long position) {
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readLimit(long limit) {
        this.writePosition = limit;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writePosition(long position) {
        this.writePosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> readSkip(long bytesToSkip) {
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeSkip(long bytesToSkip) {
        this.writePosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> writeLimit(long limit) {
        this.writeLimit = limit;
        return this;
    }

    @Override
    @NotNull
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    protected long readOffsetPositionMoved(long adding) {
        long offset = this.readPosition;
        this.readPosition += adding;
        return offset;
    }

    @Override
    protected long writeOffsetPositionMoved(long adding) {
        long oldPosition = this.writePosition;
        this.writePosition += adding;
        return oldPosition;
    }

    @Override
    protected long prewriteOffsetPositionMoved(long subtracting) throws BufferOverflowException, IORuntimeException {
        return this.readPosition -= subtracting;
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull BytesStore bytes, long offset, long length) throws IORuntimeException, BufferOverflowException, IllegalArgumentException {
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (bytes.underlyingObject() == null && length >= 32L) {
            this.rawCopy(bytes, offset, length);
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Underlying> append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IORuntimeException {
        if (cs instanceof BytesStore) {
            return (Bytes)this.write((BytesStore)cs);
        }
        int length = cs.length();
        long offset = this.writeOffsetPositionMoved(length);
        for (int i = 0; i < length; ++i) {
            int c = cs.charAt(i);
            if (c > 255) {
                c = 63;
            }
            this.writeByte(offset, (byte)c);
        }
        return this;
    }

    public void rawCopy(@NotNull BytesStore bytes, long offset, long length) throws IORuntimeException, BufferOverflowException, IllegalArgumentException {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
        if (len > 0L) {
            this.writeCheckOffset(this.writePosition(), len);
            OS.memory().copyMemory(bytes.address(offset), this.address(this.writePosition()), len);
            this.writeSkip(len);
        }
    }
}

