/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;

interface RandomCommon
extends ReferenceCounted {
    @ForceInline
    default public long start() {
        return 0L;
    }

    @ForceInline
    default public long capacity() {
        return Long.MAX_VALUE;
    }

    @ForceInline
    default public long readPosition() {
        return this.start();
    }

    @ForceInline
    default public long writePosition() {
        return this.start();
    }

    @ForceInline
    default public long readRemaining() {
        long remaining = this.readLimit() - this.readPosition();
        return remaining;
    }

    @ForceInline
    default public long writeRemaining() {
        return this.writeLimit() - this.writePosition();
    }

    @ForceInline
    default public long readLimit() {
        return this.capacity();
    }

    @ForceInline
    default public long writeLimit() {
        return this.capacity();
    }

    public long addressForRead(long var1) throws UnsupportedOperationException, BufferUnderflowException;

    default public long addressForRead(long offset, int buffer) throws UnsupportedOperationException, BufferUnderflowException {
        return this.addressForRead(offset);
    }

    public long addressForWrite(long var1) throws UnsupportedOperationException, BufferOverflowException;

    default public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    @NotNull
    public Bytes bytesForRead() throws IllegalStateException;

    @NotNull
    public Bytes bytesForWrite() throws IllegalStateException;

    public boolean compareAndSwapInt(long var1, int var3, int var4) throws BufferOverflowException;

    public void testAndSetInt(long var1, int var3, int var4);

    public boolean compareAndSwapLong(long var1, long var3, long var5) throws BufferOverflowException;

    default public boolean compareAndSwapFloat(long offset, float expected, float value) throws BufferOverflowException {
        return this.compareAndSwapInt(offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(value));
    }

    default public boolean compareAndSwapDouble(long offset, double expected, double value) throws BufferOverflowException {
        return this.compareAndSwapLong(offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(value));
    }

    public boolean sharedMemory();

    public boolean isDirectMemory();
}

