/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;

public class MappedBytes
extends AbstractBytes<Void> {
    private final MappedFile mappedFile;

    public MappedBytes(MappedFile mappedFile) throws IllegalStateException {
        super(NoBytesStore.noBytesStore(), NoBytesStore.noBytesStore().writePosition(), NoBytesStore.noBytesStore().writeLimit());
        this.mappedFile = mappedFile;
        this.clear();
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull String filename, long chunkSize) throws FileNotFoundException, IllegalStateException {
        return MappedBytes.mappedBytes(new File(filename), chunkSize);
    }

    @NotNull
    public static MappedBytes mappedBytes(@NotNull File file, long chunkSize) throws FileNotFoundException, IllegalStateException {
        MappedFile rw = new MappedFile(file, chunkSize, OS.pageSize());
        return new MappedBytes(rw);
    }

    @Override
    public BytesStore<Bytes<Void>, Void> copy() {
        return NativeBytes.copyOf(this);
    }

    @Override
    public long capacity() {
        return this.mappedFile == null ? 0L : this.mappedFile.capacity();
    }

    @Override
    public long refCount() {
        return Math.max(super.refCount(), this.mappedFile.refCount());
    }

    @Override
    protected void readCheckOffset(long offset, long adding) throws BufferUnderflowException, IORuntimeException {
        if (!this.bytesStore.inside(offset)) {
            BytesStore oldBS = this.bytesStore;
            try {
                this.bytesStore = this.mappedFile.acquireByteStore(offset);
                oldBS.release();
            }
            catch (IOException | IllegalStateException e) {
                throw new IORuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new BufferUnderflowException();
            }
        }
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) throws BufferOverflowException, IORuntimeException {
        if (!this.bytesStore.inside(offset)) {
            BytesStore oldBS = this.bytesStore;
            try {
                this.bytesStore = this.mappedFile.acquireByteStore(offset);
                oldBS.release();
            }
            catch (IOException | IllegalStateException e) {
                throw new IORuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new BufferOverflowException();
            }
        }
    }

    @Override
    public long start() {
        return 0L;
    }

    @Override
    protected void performRelease() {
        super.performRelease();
        this.mappedFile.close();
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    @Override
    @NotNull
    public Bytes<Void> write(BytesStore buffer, long offset, long length) {
        throw new UnsupportedOperationException("todo");
    }
}

