/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import org.jetbrains.annotations.NotNull;

public class UTF8StringInterner {
    private static final StringBuilderPool SBP = new StringBuilderPool();
    @NotNull
    private final String[] interner;
    private final int mask;

    public UTF8StringInterner(int capacity) throws IllegalArgumentException {
        int n = Maths.nextPower2((int)capacity, (int)128);
        this.interner = new String[n];
        this.mask = n - 1;
    }

    public String intern(@NotNull Bytes cs) throws IllegalArgumentException, UTFDataFormatRuntimeException, BufferUnderflowException {
        int h = BytesStoreHash.hash32(cs) & this.mask;
        String s = this.interner[h];
        if (cs.isEqual(s)) {
            return s;
        }
        StringBuilder sb = SBP.acquireStringBuilder();
        long pos = cs.readPosition();
        cs.parseUtf8(sb, Maths.toInt32((long)cs.readRemaining()));
        cs.readPosition(pos);
        this.interner[h] = sb.toString();
        return this.interner[h];
    }
}

