/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.StopCharTester;

public enum StopCharTesters implements StopCharTester
{
    COMMA_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 32 || ch == 44;
        }
    }
    ,
    CONTROL_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 32;
        }
    }
    ,
    SPACE_STOP{

        @Override
        public boolean isStopChar(int ch) {
            return Character.isWhitespace(ch) || ch == 0;
        }
    }
    ,
    QUOTES{

        @Override
        public boolean isStopChar(int ch) {
            return ch == 34 || ch <= 0;
        }
    }
    ,
    SINGLE_QUOTES{

        @Override
        public boolean isStopChar(int ch) {
            return ch == 39 || ch <= 0;
        }
    }
    ,
    ALL{

        @Override
        public boolean isStopChar(int ch) {
            return ch < 0;
        }
    };

}

