/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.bytes.StreamingInputStream;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.core.Maths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StreamingDataInput<S extends StreamingDataInput<S>>
extends StreamingCommon<S> {
    public S readPosition(long var1) throws BufferUnderflowException;

    public S readLimit(long var1) throws BufferUnderflowException;

    public S readSkip(long var1) throws BufferUnderflowException, IORuntimeException;

    default public void readWithLength(long length, @NotNull Consumer<S> bytesConsumer) throws BufferUnderflowException {
        this.parseWithLength(length, s -> {
            bytesConsumer.accept(s);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <R> R parseWithLength(long length, @NotNull Function<S, R> bytesConsumer) throws BufferUnderflowException {
        if (length > this.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        long limit = this.readPosition() + length;
        try {
            this.readLimit(limit);
            R r = bytesConsumer.apply(this);
            return r;
        }
        finally {
            this.readLimit(limit0);
            this.readPosition(limit);
        }
    }

    @NotNull
    default public InputStream inputStream() {
        return new StreamingInputStream(this);
    }

    default public long readStopBit() throws IORuntimeException {
        return BytesInternal.readStopBit(this);
    }

    default public double readStopBitDouble() throws IORuntimeException {
        return BytesInternal.readStopBitDouble(this);
    }

    default public boolean readBoolean() throws IORuntimeException {
        return this.readByte() != 0;
    }

    public byte readByte() throws IORuntimeException;

    public int readUnsignedByte() throws IORuntimeException;

    public short readShort() throws BufferUnderflowException, IORuntimeException;

    default public int readUnsignedShort() throws BufferUnderflowException, IORuntimeException {
        return this.readShort() & 0xFFFF;
    }

    public int readInt() throws BufferUnderflowException, IORuntimeException;

    default public long readUnsignedInt() throws BufferUnderflowException, IORuntimeException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readLong() throws BufferUnderflowException, IORuntimeException;

    public float readFloat() throws BufferUnderflowException, IORuntimeException;

    public double readDouble() throws BufferUnderflowException, IORuntimeException;

    @Nullable
    default public String readUtf8() throws BufferUnderflowException, IORuntimeException, IllegalArgumentException {
        return BytesInternal.readUtf8(this);
    }

    @Deprecated
    default public String readUTF\u0394() throws IORuntimeException, BufferUnderflowException, IllegalArgumentException {
        return BytesInternal.readUtf8(this);
    }

    @Nullable
    default public String read8bit() throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.read8bit(this);
    }

    default public <ACS extends Appendable & CharSequence> boolean readUtf8(@NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        AppendableUtil.setLength(sb, 0);
        if (this.readRemaining() <= 0L) {
            return false;
        }
        long len0 = BytesInternal.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        BytesInternal.parseUTF(this, sb, len);
        return true;
    }

    @Deprecated
    default public <ACS extends Appendable & CharSequence> boolean readUTF\u0394(@NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        return this.readUtf8(sb);
    }

    default public boolean read8bit(@NotNull Bytes b) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, IllegalStateException, BufferOverflowException {
        b.clear();
        long len0 = BytesInternal.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        b.write((BytesStore)((Object)this), this.readPosition(), len);
        this.readSkip(len);
        return true;
    }

    default public <ACS extends Appendable & CharSequence> boolean read8bit(@NotNull ACS sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException {
        AppendableUtil.setLength(sb, 0);
        long len0 = BytesInternal.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        AppendableUtil.parse8bit(this, sb, len);
        return true;
    }

    default public boolean read8bit(StringBuilder sb) throws IORuntimeException, BufferUnderflowException {
        sb.setLength(0);
        long len0 = BytesInternal.readStopBit(this);
        if (len0 == -1L) {
            return false;
        }
        int len = Maths.toUInt31((long)len0);
        AppendableUtil.parse8bit(this, sb, len);
        return true;
    }

    default public int read(@NotNull byte[] bytes) throws IORuntimeException {
        int len = (int)Math.min((long)bytes.length, this.readRemaining());
        for (int i = 0; i < len; ++i) {
            bytes[i] = this.readByte();
        }
        return len;
    }

    default public int read(@NotNull byte[] bytes, int off, int len) throws IORuntimeException {
        int len2 = (int)Math.min((long)len, this.readRemaining());
        for (int i = 0; i < len2; ++i) {
            bytes[off + i] = this.readByte();
        }
        return len2;
    }

    default public int read(@NotNull char[] bytes, int off, int len) throws IORuntimeException {
        int len2 = (int)Math.min((long)len, this.readRemaining());
        for (int i = 0; i < len2; ++i) {
            bytes[off + i] = (char)this.readUnsignedByte();
        }
        return len2;
    }

    default public void read(@NotNull ByteBuffer buffer) throws IORuntimeException {
        for (int i = (int)Math.min(this.readRemaining(), (long)buffer.remaining()); i > 0; --i) {
            buffer.put(this.readByte());
        }
    }

    public int readVolatileInt() throws BufferUnderflowException, IORuntimeException;

    public long readVolatileLong() throws BufferUnderflowException, IORuntimeException;

    public int peekUnsignedByte() throws IORuntimeException;

    public void nativeRead(long var1, long var3) throws BufferUnderflowException, IORuntimeException;

    default public <E extends Enum<E>> E readEnum(Class<E> eClass) throws IORuntimeException, BufferUnderflowException {
        return BytesInternal.readEnum(this, eClass);
    }

    @Deprecated
    default public void parseUTF(Appendable sb, int length) throws IllegalArgumentException, BufferUnderflowException, UTFDataFormatRuntimeException {
        this.parseUtf8(sb, length);
    }

    default public void parseUtf8(Appendable sb, int length) throws IllegalArgumentException, BufferUnderflowException, UTFDataFormatRuntimeException {
        AppendableUtil.setLength(sb, 0);
        BytesInternal.parseUTF(this, sb, length);
    }
}

