/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.ReferenceCounted;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BytesStore<B extends BytesStore<B, Underlying>, Underlying>
extends RandomDataInput,
RandomDataOutput<B>,
ReferenceCounted,
CharSequence {
    @Deprecated
    public static BytesStore wrap(@NotNull CharSequence cs) {
        return BytesStore.from(cs);
    }

    public static BytesStore from(@NotNull CharSequence cs) {
        if (cs instanceof BytesStore) {
            return ((BytesStore)cs).copy();
        }
        return BytesStore.wrap(cs.toString().getBytes(StandardCharsets.ISO_8859_1));
    }

    public static <B extends BytesStore<B, byte[]>> B wrap(@NotNull byte[] bytes) {
        return (B)HeapBytesStore.wrap(ByteBuffer.wrap(bytes));
    }

    public static <B extends BytesStore<B, ByteBuffer>> B wrap(@NotNull ByteBuffer bb) {
        return (B)(bb.isDirect() ? NativeBytesStore.wrap(bb) : HeapBytesStore.wrap(bb));
    }

    @NotNull
    public static PointerBytesStore nativePointer() {
        return new PointerBytesStore();
    }

    public static PointerBytesStore wrap(long address, long length) {
        PointerBytesStore pbs = BytesStore.nativePointer();
        pbs.set(address, length);
        return pbs;
    }

    public BytesStore<B, Underlying> copy() throws IllegalArgumentException;

    @Override
    default public Bytes<Underlying> bytesForRead() throws IllegalStateException {
        return (Bytes)this.bytesForWrite().readLimit(this.writeLimit());
    }

    @Override
    default public Bytes<Underlying> bytesForWrite() throws IllegalStateException {
        return new VanillaBytes(this, this.writePosition(), this.writeLimit());
    }

    default public boolean isClear() {
        return true;
    }

    @Override
    default public long realCapacity() {
        return this.capacity();
    }

    @Override
    public long capacity();

    @Nullable
    public Underlying underlyingObject();

    default public boolean inside(long offset) {
        return this.start() <= offset && offset < this.safeLimit();
    }

    default public long safeLimit() {
        return this.capacity();
    }

    default public void copyTo(@NotNull BytesStore store) throws IllegalStateException, IORuntimeException {
        long copy = Math.min(this.capacity(), store.capacity());
        int i = 0;
        while ((long)i < copy - 7L) {
            store.writeLong(i, this.readLong(i));
            ++i;
        }
        while ((long)i < copy) {
            store.writeByte(i, this.readByte(i));
            ++i;
        }
    }

    @Override
    default public B zeroOut(long start, long end) throws IllegalArgumentException, IORuntimeException {
        long i;
        if (end <= start) {
            return (B)this;
        }
        if (start < this.start()) {
            throw new IllegalArgumentException(start + " < " + this.start());
        }
        if (end > this.capacity()) {
            throw new IllegalArgumentException(end + " > " + this.capacity());
        }
        for (i = start; i < end - 7L; ++i) {
            this.writeLong(i, 0L);
        }
        while (i < end) {
            this.writeByte(i, 0);
            ++i;
        }
        return (B)this;
    }

    @Override
    default public int length() {
        return (int)Math.min(Integer.MAX_VALUE, this.readRemaining());
    }

    @Override
    default public char charAt(int index) throws IndexOutOfBoundsException {
        try {
            return (char)this.readUnsignedByte(this.readPosition() + (long)index);
        }
        catch (BufferUnderflowException e) {
            throw new IndexOutOfBoundsException(this.readPosition() + (long)index + " >= " + this.readLimit());
        }
        catch (IORuntimeException e) {
            throw new IndexOutOfBoundsException(e.toString());
        }
    }

    @Override
    @NotNull
    default public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException("todo");
    }

    @NotNull
    default public String toDebugString() {
        return BytesInternal.toDebugString(this, Integer.MAX_VALUE);
    }

    default public BytesStore bytesStore() {
        return this;
    }

    default public boolean equalBytes(@NotNull BytesStore bytesStore, long length) throws BufferUnderflowException, IORuntimeException {
        return length == 8L ? this.readLong(this.readPosition()) == bytesStore.readLong(bytesStore.readPosition()) : BytesInternal.equalBytesAny(this, bytesStore, length);
    }

    default public int byteCheckSum() throws IORuntimeException {
        int b = 0;
        for (long i = this.readPosition(); i < this.readLimit(); ++i) {
            b = (byte)(b + this.readByte(i));
        }
        return b & 0xFF;
    }

    default public boolean endsWith(char c) throws IORuntimeException {
        return this.readRemaining() > 0L && this.readUnsignedByte(this.readLimit() - 1L) == c;
    }

    default public boolean startsWith(char c) throws IORuntimeException {
        return this.readRemaining() > 0L && this.readUnsignedByte(this.readPosition()) == c;
    }

    default public boolean contentEquals(@Nullable BytesStore bytesStore) throws IORuntimeException {
        return BytesInternal.contentEqual(this, bytesStore);
    }

    default public String to8bitString() throws IORuntimeException, IllegalArgumentException {
        return BytesInternal.to8bitString(this);
    }
}

