/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBytes<Underlying>
implements Bytes<Underlying> {
    protected BytesStore<Bytes<Underlying>, Underlying> bytesStore;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    private long readPosition;
    private long writePosition;
    private long writeLimit;

    AbstractBytes(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore, long writePosition, long writeLimit) {
        this.bytesStore = bytesStore;
        bytesStore.reserve();
        this.readPosition = bytesStore.readPosition();
        this.writePosition = writePosition;
        this.writeLimit = writeLimit;
    }

    @Override
    public Bytes<Underlying> clear() {
        this.readPosition = this.writePosition = this.start();
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    @ForceInline
    public long readLimit() {
        return this.writePosition;
    }

    @Override
    @ForceInline
    public long writeLimit() {
        return this.writeLimit;
    }

    @Override
    @ForceInline
    public long realCapacity() {
        return this.bytesStore.capacity();
    }

    @Override
    @ForceInline
    public long capacity() {
        return this.bytesStore.capacity();
    }

    @Override
    public Underlying underlyingObject() {
        return this.bytesStore.underlyingObject();
    }

    @Override
    @ForceInline
    public long start() {
        return this.bytesStore.start();
    }

    @Override
    @ForceInline
    public long readPosition() {
        return this.readPosition;
    }

    @Override
    @ForceInline
    public long writePosition() {
        return this.writePosition;
    }

    @Override
    @ForceInline
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        this.writeCheckOffset(offset, 4L);
        return this.bytesStore.compareAndSwapInt(offset, expected, value);
    }

    @Override
    @ForceInline
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        this.writeCheckOffset(offset, 8L);
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    @Override
    @ForceInline
    public Bytes<Underlying> readPosition(long position) {
        if (position < this.start()) {
            throw new BufferUnderflowException();
        }
        if (position > this.readLimit()) {
            throw new BufferOverflowException();
        }
        this.readPosition = position;
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> readLimit(long limit) {
        if (limit < this.start()) {
            throw new BufferUnderflowException();
        }
        if (limit > this.writeLimit()) {
            throw new BufferOverflowException();
        }
        this.writePosition = limit;
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writePosition(long position) {
        if (position < this.readPosition()) {
            throw new BufferUnderflowException();
        }
        if (position > this.writeLimit()) {
            throw new BufferOverflowException();
        }
        this.writePosition = position;
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> readSkip(long bytesToSkip) {
        this.readOffsetPositionMoved(bytesToSkip);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeSkip(long bytesToSkip) {
        this.writeOffsetPositionMoved(bytesToSkip);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeLimit(long limit) {
        if (limit < this.start()) {
            throw new BufferUnderflowException();
        }
        long capacity = this.capacity();
        if (limit > capacity) {
            assert (false) : "cant set limit=" + limit + " > " + "capacity=" + capacity;
            throw new BufferOverflowException();
        }
        this.writeLimit = limit;
        return this;
    }

    void performRelease() {
        this.bytesStore.release();
        this.bytesStore = NoBytesStore.noBytesStore();
    }

    @Override
    @ForceInline
    public byte readByte() {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readByte(offset);
        }
        catch (BufferOverflowException e) {
            return 0;
        }
    }

    @Override
    @ForceInline
    public int peekUnsignedByte() {
        try {
            return this.readRemaining() > 0L ? this.bytesStore.readUnsignedByte(this.readPosition) : -1;
        }
        catch (BufferOverflowException e) {
            return -1;
        }
    }

    @Override
    @ForceInline
    public short readShort() {
        long offset = this.readOffsetPositionMoved(2L);
        return this.bytesStore.readShort(offset);
    }

    @Override
    @ForceInline
    public int readInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readInt(offset);
    }

    @Override
    @ForceInline
    public long readLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readLong(offset);
    }

    @Override
    @ForceInline
    public float readFloat() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    @ForceInline
    public double readDouble() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readDouble(offset);
    }

    @Override
    @ForceInline
    public int readVolatileInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    @ForceInline
    public long readVolatileLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readVolatileLong(offset);
    }

    private long readOffsetPositionMoved(long adding) {
        long offset = this.readPosition;
        this.readCheckOffset(this.readPosition, adding);
        this.readPosition += adding;
        assert (this.readPosition <= this.readLimit());
        return offset;
    }

    public void reserve() {
        this.refCount.reserve();
    }

    public void release() {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeByte(long offset, byte i) {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeByte(offset, i);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeShort(long offset, short i) {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeInt(long offset, int i) {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeOrderedInt(long offset, int i) {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeLong(long offset, long i) {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeLong(offset, i);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeOrderedLong(long offset, long i) {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeFloat(long offset, float d) {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeFloat(offset, d);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeDouble(long offset, double d) {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    @ForceInline
    public void write(long offsetInRDO, ByteBuffer bytes, int offset, int length) {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @ForceInline
    public Bytes<Underlying> write(long offsetInRDO, RandomDataInput bytes, long offset, long length) {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @ForceInline
    void writeCheckOffset(long offset, long adding) {
        assert (this.writeCheckOffset0(offset, adding));
    }

    private boolean writeCheckOffset0(long offset, long adding) {
        if (offset < this.start()) {
            throw new BufferUnderflowException();
        }
        if (offset + adding > this.writeLimit()) {
            assert (offset + adding <= this.writeLimit()) : "cant add bytes past the limit : limit=" + this.writeLimit() + ",offset=" + offset + ",adding=" + adding;
            throw new BufferOverflowException();
        }
        return true;
    }

    @Override
    @ForceInline
    public byte readByte(long offset) {
        this.readCheckOffset(offset, 1L);
        return this.bytesStore.readByte(offset);
    }

    @Override
    @ForceInline
    public short readShort(long offset) {
        this.readCheckOffset(offset, 2L);
        return this.bytesStore.readShort(offset);
    }

    @Override
    @ForceInline
    public int readInt(long offset) {
        this.readCheckOffset(offset, 4L);
        return this.bytesStore.readInt(offset);
    }

    @Override
    @ForceInline
    public long readLong(long offset) {
        this.readCheckOffset(offset, 8L);
        return this.bytesStore.readLong(offset);
    }

    @Override
    @ForceInline
    public float readFloat(long offset) {
        this.readCheckOffset(offset, 4L);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    @ForceInline
    public double readDouble(long offset) {
        this.readCheckOffset(offset, 8L);
        return this.bytesStore.readDouble(offset);
    }

    @ForceInline
    void readCheckOffset(long offset, long adding) {
        assert (this.readCheckOffset0(offset, adding));
    }

    @ForceInline
    private boolean readCheckOffset0(long offset, long adding) {
        if (offset < this.start()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.readLimit();
        if (offset + adding > limit0) {
            throw new BufferUnderflowException();
        }
        return true;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeByte(byte i8) {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @ForceInline
    private long writeOffsetPositionMoved(long adding) {
        long oldPosition = this.writePosition;
        this.writeCheckOffset(this.writePosition, adding);
        this.writePosition += adding;
        return oldPosition;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeShort(short i16) {
        long offset = this.writeOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeInt(int i) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeLong(long i64) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeFloat(float f) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeFloat(offset, f);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeDouble(double d) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> write(byte[] bytes, int offset, int length) {
        long offsetInRDO = this.writeOffsetPositionMoved(length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> write(ByteBuffer buffer) {
        this.bytesStore.write(this.writePosition, buffer, buffer.position(), buffer.limit());
        this.writePosition += (long)buffer.remaining();
        assert (this.writePosition <= this.writeLimit());
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeOrderedInt(int i) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @ForceInline
    public Bytes<Underlying> writeOrderedLong(long i) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    public long address(long offset) throws UnsupportedOperationException {
        return this.bytesStore.address(offset);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("todo");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bytes)) {
            return false;
        }
        Bytes b2 = (Bytes)obj;
        long remaining = this.readRemaining();
        return b2.readRemaining() == remaining && this.equalsBytes(b2, remaining);
    }

    public boolean equalsBytes(Bytes b2, long remaining) {
        long i;
        for (i = 0L; i < remaining - 7L; ++i) {
            if (this.readLong(this.readPosition() + i) == b2.readLong(b2.readPosition() + i)) continue;
            return false;
        }
        while (i < remaining) {
            if (this.readByte(this.readPosition() + i) != b2.readByte(b2.readPosition() + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return BytesUtil.toString(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.refCount.releaseAll();
    }

    @Override
    @ForceInline
    public void nativeRead(long address, long size) {
        this.bytesStore.nativeRead(this.readPosition(), address, size);
        this.readSkip(size);
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long size) {
        this.bytesStore.nativeWrite(address, this.writePosition(), size);
        this.writeSkip(size);
    }

    @Override
    @ForceInline
    public void nativeRead(long position, long address, long size) {
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    @ForceInline
    public void nativeWrite(long address, long position, long size) {
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    public BytesStore bytesStore() {
        return this.bytesStore;
    }
}

