/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.UnderflowMode;
import net.openhft.chronicle.bytes.ZeroedBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;

public class NativeBytes<Underlying>
extends ZeroedBytes<Underlying> {
    NativeBytes(BytesStore store) {
        super(store, UnderflowMode.PADDED, Long.MAX_VALUE);
    }

    public static NativeBytes<Void> nativeBytes() {
        return new NativeBytes<Void>(NoBytesStore.noBytesStore());
    }

    public static NativeBytes<Void> nativeBytes(long initialCapacity) {
        return new NativeBytes<Void>(NativeBytesStore.nativeStoreWithFixedCapacity(initialCapacity));
    }

    public static BytesStore<Bytes<Void>, Void> copyOf(Bytes bytes) {
        long remaining = bytes.readRemaining();
        NativeBytes<Void> bytes2 = NativeBytes.nativeBytes(remaining);
        bytes2.write(bytes, 0L, remaining);
        return bytes2;
    }

    @Override
    public long capacity() {
        return Long.MAX_VALUE;
    }

    @Override
    protected void writeCheckOffset(long offset, long adding) {
        if (!this.bytesStore.inStore(offset + adding)) {
            this.checkResize(offset + adding);
        }
    }

    @Override
    public void ensureCapacity(long size) {
        this.writeCheckOffset(size, 0L);
    }

    private void checkResize(long endOfBuffer) {
        if (!this.isElastic()) {
            throw new BufferOverflowException();
        }
        this.resize(endOfBuffer);
    }

    @Override
    public int readVolatileInt(long offset) {
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(long offset) {
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public boolean isElastic() {
        return true;
    }

    private void resize(long endOfBuffer) {
        if (endOfBuffer < 0L) {
            throw new IllegalArgumentException();
        }
        long ps = OS.pageSize();
        long size = Math.max(endOfBuffer, this.bytesStore.capacity() * 3L / 2L) + ps & (ps - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        NativeBytesStore<Object> store = this.bytesStore.underlyingObject() instanceof ByteBuffer ? NativeBytesStore.elasticByteBuffer(Maths.toInt32((long)size)) : NativeBytesStore.lazyNativeBytesStoreWithFixedCapacity(size);
        this.bytesStore.copyTo(store);
        this.bytesStore.release();
        this.bytesStore = store;
    }

    @Override
    public Bytes<Underlying> write(BytesStore bytes, long offset, long length) {
        if (bytes instanceof NativeBytes) {
            long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
            this.writeCheckOffset(this.writePosition(), len);
            OS.memory().copyMemory(bytes.address() + offset, this.address() + this.writePosition(), len);
            this.writeSkip(len);
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    public void write(String str, int offset, int length) {
        char[] chars = str.toCharArray();
        long position = this.writePosition();
        this.ensureCapacity(position + (long)length);
        NativeBytesStore nbs = (NativeBytesStore)this.bytesStore;
        nbs.write8bit(position, chars, offset, length);
        this.writeSkip(length);
    }

    public void read8Bit(char[] chars, int length) {
        long position = this.readPosition();
        NativeBytesStore nbs = (NativeBytesStore)this.bytesStore;
        nbs.read8bit(position, chars, length);
    }
}

