/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.core.Maths;
import org.jetbrains.annotations.NotNull;

public class VanillaBytes<Underlying>
extends AbstractBytes<Underlying>
implements Byteable<Underlying> {
    public VanillaBytes(@NotNull BytesStore bytesStore) {
        this(bytesStore, bytesStore.writePosition(), bytesStore.writeLimit());
    }

    public VanillaBytes(@NotNull BytesStore bytesStore, long writePosition, long writeLimit) {
        super(bytesStore, writePosition, writeLimit);
    }

    @Override
    public void bytesStore(BytesStore<Bytes<Underlying>, Underlying> byteStore, long offset, long length) {
        this.bytesStore(byteStore);
        this.readLimit(offset + length);
        this.writeLimit(offset + length);
        this.readPosition(offset);
    }

    private void bytesStore(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore) {
        BytesStore oldBS = this.bytesStore;
        this.bytesStore = bytesStore;
        oldBS.release();
        this.clear();
    }

    @Override
    public long maxSize() {
        return this.readRemaining();
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    public Bytes<Underlying> bytesForRead() {
        return this.isClear() ? new VanillaBytes<Underlying>(this.bytesStore, this.bytesStore.writeLimit(), this.bytesStore.writeLimit()) : new SubBytes(this.bytesStore, this.readPosition(), this.readLimit());
    }

    @Override
    public long realCapacity() {
        return this.bytesStore.realCapacity();
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        if (this.bytesStore.underlyingObject() instanceof ByteBuffer) {
            ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.readRemaining()));
            ByteBuffer bbu = (ByteBuffer)this.bytesStore.underlyingObject();
            ByteBuffer slice = bbu.slice();
            slice.position((int)this.readPosition());
            slice.limit((int)this.readLimit());
            bb.put(slice);
            bb.clear();
            return BytesStore.wrap(bb);
        }
        return NativeBytes.copyOf(this);
    }

    @Override
    public Bytes<Underlying> write(BytesStore bs, long offset, long length) {
        long i;
        for (i = 0L; i < length - 7L; i += 8L) {
            this.writeLong(bs.readLong(offset + i));
        }
        while (i < length) {
            this.writeByte(bs.readByte(offset + i));
            ++i;
        }
        return this;
    }
}

