/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.ArrayAccessors;
import net.openhft.chronicle.bytes.ByteBufferAccess;
import net.openhft.chronicle.bytes.NativeAccess;
import sun.nio.ch.DirectBuffer;

interface ByteBufferAccessor<T>
extends Accessor.Full<ByteBuffer, T> {
    public static ByteBufferAccessor<?> unchecked(ByteBuffer buffer) {
        return buffer.isDirect() ? Direct.INSTANCE : Heap.INSTANCE;
    }

    public static ByteBufferAccessor<ByteBuffer> checked() {
        return Generic.INSTANCE;
    }

    public static enum Generic implements ByteBufferAccessor<ByteBuffer>
    {
        INSTANCE;


        @Override
        public Access<ByteBuffer> access(ByteBuffer buffer) {
            return ByteBufferAccess.INSTANCE;
        }

        @Override
        public ByteBuffer handle(ByteBuffer buffer) {
            return buffer;
        }

        @Override
        public long offset(ByteBuffer buffer, long bufferIndex) {
            return bufferIndex;
        }
    }

    public static enum Heap implements ByteBufferAccessor<byte[]>
    {
        INSTANCE;


        @Override
        public Access<byte[]> access(ByteBuffer buffer) {
            return NativeAccess.instance();
        }

        @Override
        public byte[] handle(ByteBuffer buffer) {
            return buffer.array();
        }

        @Override
        public long offset(ByteBuffer buffer, long bufferIndex) {
            return ArrayAccessors.BYTE_BASE + (long)buffer.arrayOffset() + bufferIndex;
        }
    }

    public static enum Direct implements ByteBufferAccessor<Void>
    {
        INSTANCE;


        @Override
        public Access<Void> access(ByteBuffer buffer) {
            return NativeAccess.instance();
        }

        @Override
        public Void handle(ByteBuffer buffer) {
            return null;
        }

        @Override
        public long offset(ByteBuffer buffer, long bufferIndex) {
            return ((DirectBuffer)((Object)buffer)).address() + bufferIndex;
        }
    }
}

