/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.SubBytes;
import org.jetbrains.annotations.NotNull;

public class VanillaBytes<Underlying>
extends AbstractBytes<Underlying>
implements Byteable<Underlying> {
    public VanillaBytes(@NotNull BytesStore bytesStore) {
        super(bytesStore);
    }

    @Override
    public void bytesStore(BytesStore<Bytes<Underlying>, Underlying> byteStore, long offset, long length) {
        this.bytesStore(byteStore);
        this.limit(offset + length);
        this.position(offset);
    }

    public void bytesStore(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore) {
        BytesStore oldBS = this.bytesStore;
        this.bytesStore = bytesStore;
        oldBS.release();
        this.clear();
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> bytesStore() {
        return this.bytesStore;
    }

    @Override
    public long offset() {
        return this.position();
    }

    @Override
    public long maxSize() {
        return this.remaining();
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    public Bytes<Underlying> bytes() {
        boolean isClear = this.start() == this.position() && this.limit() == this.capacity();
        return isClear ? new VanillaBytes<Underlying>(this.bytesStore) : new SubBytes(this.bytesStore, this.position(), this.limit());
    }

    @Override
    public long realCapacity() {
        return this.bytesStore.realCapacity();
    }
}

