/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import net.openhft.chronicle.bytes.Access;
import net.openhft.chronicle.bytes.Accessor;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.UnderflowMode;
import net.openhft.chronicle.bytes.WriteAccess;
import net.openhft.chronicle.core.ReferenceCounter;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBytes<Underlying>
implements Bytes<Underlying> {
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    protected BytesStore<Bytes<Underlying>, Underlying> bytesStore = NoBytesStore.noBytesStore();
    long mark = -1L;
    private long position;
    private long limit;
    private UnderflowMode underflowMode;

    public AbstractBytes(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore) {
        this.bytesStore = bytesStore;
        bytesStore.reserve();
        this.clear();
    }

    @Override
    public Bytes clear() {
        this.position = this.start();
        this.limit = this.isElastic() ? this.capacity() : this.realCapacity();
        return this;
    }

    @Override
    public long realCapacity() {
        return this.bytesStore.capacity();
    }

    @Override
    public long capacity() {
        return this.bytesStore.capacity();
    }

    @Override
    public Underlying underlyingObject() {
        return this.bytesStore.underlyingObject();
    }

    @Override
    public long start() {
        return this.bytesStore.start();
    }

    @Override
    public Bytes<Underlying> zeroOut(long start, long end) {
        this.bytesStore.zeroOut(start, end);
        return this;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        this.writeCheckOffset(offset, 4L);
        return this.bytesStore.compareAndSwapInt(offset, expected, value);
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        this.writeCheckOffset(offset, 8L);
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    @Override
    public Bytes position(long position) {
        if (position < this.start()) {
            throw new BufferUnderflowException();
        }
        if (position > this.limit()) {
            throw new BufferOverflowException();
        }
        this.position = position;
        return this;
    }

    @Override
    public Bytes<Underlying> skip(long bytesToSkip) {
        this.readOffsetPositionMoved(bytesToSkip);
        return this;
    }

    @Override
    public Bytes limit(long limit) {
        if (limit < this.start()) {
            throw new BufferUnderflowException();
        }
        long capacity = this.capacity();
        if (limit > capacity) {
            assert (false) : "cant set limit=" + limit + " > " + "capacity=" + capacity;
            throw new BufferOverflowException();
        }
        this.limit = limit;
        return this;
    }

    @Override
    public Bytes<Underlying> flip() {
        this.limit = this.position;
        this.position = this.start();
        assert (this.limit >= this.start());
        return this;
    }

    protected void performRelease() {
        this.bytesStore.release();
        this.bytesStore = NoBytesStore.noBytesStore();
    }

    @Override
    public UnderflowMode underflowMode() {
        return this.underflowMode;
    }

    @Override
    public Bytes<Underlying> underflowMode(UnderflowMode underflowMode) {
        this.underflowMode = underflowMode;
        return this;
    }

    @Override
    public byte readByte() {
        try {
            long offset = this.readOffsetPositionMoved(1L);
            return this.bytesStore.readByte(offset);
        }
        catch (BufferOverflowException e) {
            return 0;
        }
    }

    @Override
    public int peekUnsignedByte() {
        try {
            return this.remaining() > 0L ? this.bytesStore.readUnsignedByte(this.position) : -1;
        }
        catch (BufferOverflowException e) {
            return -1;
        }
    }

    @Override
    public short readShort() {
        long offset = this.readOffsetPositionMoved(2L);
        return this.bytesStore.readShort(offset);
    }

    @Override
    public int readInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readInt(offset);
    }

    @Override
    public long readLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readLong(offset);
    }

    @Override
    public float readFloat() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    public double readDouble() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readDouble(offset);
    }

    @Override
    public int peakVolatileInt() {
        this.readCheckOffset(this.position, 4L);
        return this.bytesStore.readVolatileInt(this.position);
    }

    @Override
    public void read(byte[] bytes) {
        this.read(Accessor.byteArrayAccessor(), bytes, 0L, bytes.length);
    }

    private <S, T> void read(Accessor.Full<S, T> accessor, S target, long off, long len) {
        long sourceOffset = this.accessPositionOffset();
        long size = accessor.size(len);
        this.skip(size);
        Access.copy(this.access(), this.accessHandle(), sourceOffset, (WriteAccess)accessor.access(target), accessor.handle(target), accessor.offset(target, off), size);
    }

    @Override
    public void read(ByteBuffer buffer) {
        long read = Math.min(this.remaining(), (long)buffer.remaining());
        this.read(Accessor.uncheckedByteBufferAccessor(buffer), buffer, buffer.position(), read);
        buffer.position((int)((long)buffer.position() + read));
    }

    @Override
    public int readVolatileInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readVolatileLong(offset);
    }

    protected long readOffsetPositionMoved(long adding) {
        long offset = this.position;
        this.readCheckOffset(this.position, adding);
        this.position += adding;
        assert (this.position <= this.limit());
        return offset;
    }

    public void reserve() {
        this.refCount.reserve();
    }

    public void release() {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    public Bytes writeByte(long offset, byte i) {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeByte(offset, i);
        return this;
    }

    @Override
    public Bytes writeShort(long offset, short i) {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    public Bytes writeInt(long offset, int i) {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    public Bytes writeOrderedInt(long offset, int i) {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    public Bytes writeLong(long offset, long i) {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeLong(offset, i);
        return this;
    }

    @Override
    public Bytes<Underlying> writeOrderedLong(long offset, long i) {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    public Bytes writeFloat(long offset, float d) {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeFloat(offset, d);
        return this;
    }

    @Override
    public Bytes writeDouble(long offset, double d) {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    public Bytes<Underlying> write(long offsetInRDO, byte[] bytes, int offset, int length) {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    public Bytes<Underlying> write(long offsetInRDO, ByteBuffer bytes, int offset, int length) {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    public Bytes<Underlying> write(long offsetInRDO, Bytes bytes, long offset, long length) {
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    protected void writeCheckOffset(long offset, long adding) {
        assert (this.writeCheckOffset0(offset, adding));
    }

    private boolean writeCheckOffset0(long offset, long adding) {
        if (offset < this.start()) {
            throw new BufferUnderflowException();
        }
        if (offset + adding > this.limit()) {
            assert (offset + adding <= this.limit()) : "cant add bytes past the limit : limit=" + this.limit + ",offset=" + offset + ",adding=" + adding;
            throw new BufferOverflowException();
        }
        return true;
    }

    @Override
    public byte readByte(long offset) {
        this.readCheckOffset(offset, 1L);
        return this.bytesStore.readByte(offset);
    }

    @Override
    public short readShort(long offset) {
        this.readCheckOffset(offset, 2L);
        return this.bytesStore.readShort(offset);
    }

    @Override
    public int readInt(long offset) {
        this.readCheckOffset(offset, 4L);
        return this.bytesStore.readInt(offset);
    }

    @Override
    public long readLong(long offset) {
        this.readCheckOffset(offset, 8L);
        return this.bytesStore.readLong(offset);
    }

    @Override
    public float readFloat(long offset) {
        this.readCheckOffset(offset, 4L);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    public double readDouble(long offset) {
        this.readCheckOffset(offset, 8L);
        return this.bytesStore.readDouble(offset);
    }

    protected void readCheckOffset(long offset, long adding) {
        assert (this.readCheckOffset0(offset, adding));
    }

    protected boolean readCheckOffset0(long offset, long adding) {
        if (offset < this.start()) {
            throw new BufferUnderflowException();
        }
        long limit0 = this.limit();
        if (offset + adding > limit0) {
            throw new BufferUnderflowException();
        }
        return true;
    }

    @Override
    public Bytes<Underlying> writeByte(byte i8) {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    protected long writeOffsetPositionMoved(long adding) {
        long oldPosition = this.position;
        this.writeCheckOffset(this.position, adding);
        this.position += adding;
        return oldPosition;
    }

    @Override
    public Bytes<Underlying> writeShort(short i16) {
        long offset = this.writeOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    public Bytes<Underlying> writeInt(int i) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    public Bytes<Underlying> writeLong(long i64) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    public Bytes<Underlying> writeFloat(float f) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeFloat(offset, f);
        return this;
    }

    @Override
    public Bytes<Underlying> writeDouble(double d) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    public Bytes<Underlying> write(Bytes bytes) {
        long write = Math.min(this.remaining(), bytes.remaining());
        long offset = bytes.position();
        bytes.skip(write);
        this.write(bytes, offset, write);
        return this;
    }

    @Override
    public Bytes<Underlying> write(Bytes bytes, long offset, long length) {
        long write = Math.min(this.remaining(), length);
        long targetOffset = this.writeOffsetPositionMoved(write);
        Access.copy(bytes.access(), bytes.accessHandle(), bytes.accessOffset(offset), this.access(), this.accessHandle(), this.accessOffset(targetOffset), write);
        return this;
    }

    @Override
    public Bytes<Underlying> write(byte[] bytes, int offset, int length) {
        long offsetInRDO = this.writeOffsetPositionMoved(length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
        return this;
    }

    @Override
    public Bytes<Underlying> write(ByteBuffer buffer) {
        this.bytesStore.write(this.position, buffer, buffer.position(), buffer.limit());
        this.position += (long)buffer.remaining();
        assert (this.position <= this.limit());
        return this;
    }

    @Override
    public Bytes<Underlying> writeOrderedInt(int i) {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    public Bytes<Underlying> writeOrderedLong(long i) {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    private long bufferOverflowOnWrite() {
        throw new BufferOverflowException();
    }

    private long bufferUnderflowOnRead() {
        throw new BufferUnderflowException();
    }

    @Override
    public long address() {
        return this.bytesStore.address();
    }

    @Override
    public Underlying accessHandle() {
        return (Underlying)this.bytesStore.accessHandle();
    }

    @Override
    public long accessOffset(long randomOffset) {
        return this.bytesStore.accessOffset(randomOffset);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Bytes)) {
            return false;
        }
        Bytes b2 = (Bytes)obj;
        long remaining = this.remaining();
        if (b2.remaining() != remaining) {
            return false;
        }
        return Access.equivalent(this.access(), this.accessHandle(), this.accessPositionOffset(), b2.access(), b2.accessHandle(), b2.accessPositionOffset(), remaining);
    }

    @Override
    public String toString() {
        return BytesUtil.toString(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.refCount.releaseAll();
    }

    @Override
    public final Bytes mark() {
        this.mark = this.position;
        return this;
    }

    @Override
    public final Bytes reset() {
        long m = this.mark;
        if (m < 0L) {
            throw new InvalidMarkException();
        }
        assert (this.position <= this.limit());
        this.position = m;
        return this;
    }

    @Override
    public Access<Underlying> access() {
        return this.bytesStore.access();
    }

    @Override
    public void nativeRead(long address, long size) {
        this.bytesStore.nativeRead(this.position(), address, size);
        this.skip(size);
    }

    @Override
    public void nativeWrite(long address, long size) {
        this.bytesStore.nativeWrite(address, this.position(), size);
        this.skip(size);
    }

    @Override
    public void nativeRead(long position, long address, long size) {
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        this.bytesStore.nativeWrite(address, position, size);
    }
}

