/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.algo;

import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.Maths;
import org.jetbrains.annotations.NotNull;

public enum VanillaBytesStoreHash implements BytesStoreHash<BytesStore>
{
    INSTANCE;

    private static final int TOP_BYTES;
    static final int K0 = -978308811;
    static final int K1 = 492187003;
    static final int M0 = 1228037679;
    static final int M1 = 846538563;
    static final int M2 = -189059537;
    static final int M3 = 1248073673;

    @Override
    public long applyAsLong(@NotNull BytesStore store) {
        int i;
        long start = store.readPosition();
        int remaining = (int)store.readRemaining();
        long h0 = remaining;
        long h1 = 0L;
        for (i = 0; i < remaining - 31; i += 32) {
            h0 *= -978308811L;
            h1 *= 492187003L;
            long addrI = start + (long)i;
            long l0 = store.readLong(addrI);
            int l0a = store.readInt(addrI + (long)TOP_BYTES);
            long l1 = store.readLong(addrI + 8L);
            int l1a = store.readInt(addrI + 8L + (long)TOP_BYTES);
            long l2 = store.readLong(addrI + 16L);
            int l2a = store.readInt(addrI + 16L + (long)TOP_BYTES);
            long l3 = store.readLong(addrI + 24L);
            int l3a = store.readInt(addrI + 24L + (long)TOP_BYTES);
            h0 += (l0 + (long)l1a) * 1228037679L + (l2 + (long)l3a) * -189059537L;
            h1 += (l1 + (long)l0a) * 846538563L + (l3 + (long)l2a) * 1248073673L;
        }
        int left = remaining - i;
        if (left > 0) {
            h0 *= -978308811L;
            h1 *= 492187003L;
            long addrI = start + (long)i;
            long l0 = store.readIncompleteLong(addrI);
            int l0a = (int)(l0 >> 32);
            long l1 = store.readIncompleteLong(addrI + 8L);
            int l1a = (int)(l1 >> 32);
            long l2 = store.readIncompleteLong(addrI + 16L);
            int l2a = (int)(l2 >> 32);
            long l3 = store.readIncompleteLong(addrI + 24L);
            int l3a = (int)(l3 >> 32);
            h0 += (l0 + (long)l1a) * 1228037679L + (l2 + (long)l3a) * -189059537L;
            h1 += (l1 + (long)l0a) * 846538563L + (l3 + (long)l2a) * 1248073673L;
        }
        return Maths.agitate((long)h0) ^ Maths.agitate((long)h1);
    }

    static {
        TOP_BYTES = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 4 : 0;
    }
}

