/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class VanillaBytes<Underlying>
extends AbstractBytes<Underlying>
implements Byteable<Underlying> {
    public VanillaBytes(@NotNull BytesStore bytesStore) {
        this(bytesStore, bytesStore.writePosition(), bytesStore.writeLimit());
    }

    public VanillaBytes(@NotNull BytesStore bytesStore, long writePosition, long writeLimit) {
        super(bytesStore, writePosition, writeLimit);
    }

    @NotNull
    public static VanillaBytes<Void> vanillaBytes() {
        return new VanillaBytes<Void>(NoBytesStore.noBytesStore());
    }

    @Override
    public void bytesStore(@NotNull BytesStore<Bytes<Underlying>, Underlying> byteStore, long offset, long length) {
        this.bytesStore(byteStore);
        this.readLimit(offset + length);
        this.writeLimit(offset + length);
        this.readPosition(offset);
    }

    private void bytesStore(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore) {
        BytesStore oldBS = this.bytesStore;
        this.bytesStore = bytesStore;
        oldBS.release();
        this.clear();
    }

    @Override
    public long maxSize() {
        return this.readRemaining();
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    @NotNull
    public Bytes<Underlying> bytesForRead() {
        return this.isClear() ? new VanillaBytes<Underlying>(this.bytesStore, this.writePosition(), this.bytesStore.writeLimit()) : new SubBytes(this.bytesStore, this.readPosition(), this.readLimit());
    }

    @Override
    public boolean isEqual(String s) {
        if (s == null || (long)s.length() != this.readRemaining()) {
            return false;
        }
        char[] chars = StringUtils.extractChars((String)s);
        if (this.bytesStore instanceof NativeBytesStore) {
            NativeBytesStore bs = (NativeBytesStore)this.bytesStore;
            long address = bs.address + bs.translate(this.readPosition);
            Memory memory = bs.memory;
            for (int i = 0; i < chars.length; ++i) {
                int b = memory.readByte(address + (long)i) & 0xFF;
                if (b == chars[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < chars.length; ++i) {
                int b = this.bytesStore.readByte(this.readPosition + (long)i) & 0xFF;
                if (b == chars[i]) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public long realCapacity() {
        return this.bytesStore.realCapacity();
    }

    @Override
    @NotNull
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        if (this.bytesStore.underlyingObject() instanceof ByteBuffer) {
            ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.readRemaining()));
            ByteBuffer bbu = (ByteBuffer)this.bytesStore.underlyingObject();
            ByteBuffer slice = bbu.slice();
            slice.position((int)this.readPosition());
            slice.limit((int)this.readLimit());
            bb.put(slice);
            bb.clear();
            return BytesStore.wrap(bb);
        }
        return NativeBytes.copyOf(this);
    }

    @Override
    @NotNull
    public Bytes<Underlying> write(@NotNull BytesStore bytes, long offset, long length) {
        if (bytes.bytesStore() instanceof NativeBytesStore && length >= 64L) {
            long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
            if (len > 0L) {
                this.writeCheckOffset(this.writePosition(), len);
                OS.memory().copyMemory(bytes.address(offset), this.address(this.writePosition()), len);
                this.writeSkip(len);
            }
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    @Override
    public Bytes<Underlying> write8bit(@NotNull CharSequence str, int offset, int length) {
        this.writeStopBit(length);
        this.write(str, offset, length);
        return this;
    }

    public void write(long position, @NotNull CharSequence str, int offset, int length) {
        if (!(str instanceof String)) {
            throw new UnsupportedOperationException();
        }
        char[] chars = ((String)str).toCharArray();
        this.ensureCapacity(position + (long)length);
        NativeBytesStore nbs = (NativeBytesStore)this.bytesStore;
        nbs.write8bit(position, chars, offset, length);
    }

    @Override
    @NotNull
    public VanillaBytes append(CharSequence str, int start, int end) {
        if (this.bytesStore() instanceof NativeBytesStore) {
            if (str instanceof BytesStore) {
                this.write((BytesStore)str, (long)start, (long)(end - start));
                return this;
            }
            if (str instanceof String) {
                this.write(str, start, end - start);
                return this;
            }
        }
        super.append(str, start, end);
        return this;
    }

    @Override
    public boolean equalBytes(BytesStore b, long remaining) {
        if (this.bytesStore instanceof NativeBytesStore && b instanceof VanillaBytes && b.bytesStore() instanceof NativeBytesStore) {
            long i;
            VanillaBytes b2 = (VanillaBytes)b;
            NativeBytesStore nbs0 = (NativeBytesStore)this.bytesStore;
            NativeBytesStore nbs2 = (NativeBytesStore)b2.bytesStore();
            for (i = 0L; i < remaining - 7L; ++i) {
                long l2;
                long addr0 = nbs0.address + this.readPosition() - nbs0.start() + i;
                long addr2 = nbs2.address + b2.readPosition() - nbs2.start() + i;
                long l0 = nbs0.memory.readLong(addr0);
                if (l0 == (l2 = nbs2.memory.readLong(addr2))) continue;
                return false;
            }
            while (i < remaining) {
                byte b1;
                long offset2 = this.readPosition() + i - nbs0.start();
                long offset21 = b2.readPosition() + i - nbs2.start();
                byte b0 = nbs0.memory.readByte(nbs0.address + offset2);
                if (b0 != (b1 = nbs2.memory.readByte(nbs2.address + offset21))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equalBytes(b, remaining);
    }

    public void read8Bit(char[] chars, int length) {
        long position = this.readPosition();
        NativeBytesStore nbs = (NativeBytesStore)this.bytesStore();
        nbs.read8bit(position, chars, length);
    }

    @Override
    public int byteCheckSum() {
        if (this.readLimit() >= Integer.MAX_VALUE || this.start() != 0L) {
            return super.byteCheckSum();
        }
        int b = 0;
        NativeBytesStore bytesStore = (NativeBytesStore)this.bytesStore();
        int lim = (int)this.readLimit();
        for (int i = (int)this.readPosition(); i < lim; ++i) {
            b = (byte)(b + bytesStore.memory.readByte(bytesStore.address + (long)i));
        }
        return b & 0xFF;
    }

    @Override
    public void appendUTF(char[] chars, int offset, int length) {
        this.ensureCapacity(this.readPosition() + (long)length);
        if (this.bytesStore instanceof NativeBytesStore) {
            this.writePosition(((NativeBytesStore)this.bytesStore).appendUTF(this.writePosition(), chars, offset, length));
        } else {
            super.appendUTF(chars, offset, length);
        }
    }
}

