/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.StreamingCommon;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.NotNull;

public interface StreamingDataOutput<S extends StreamingDataOutput<S>>
extends StreamingCommon<S> {
    @NotNull
    default public OutputStream outputStream() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    default public S writeStopBit(long x) {
        BytesUtil.writeStopBit(this, x);
        return (S)this;
    }

    default public S writeStopBit(double d) {
        BytesUtil.writeStopBit(this, d);
        return (S)this;
    }

    public S writePosition(long var1);

    public S writeLimit(long var1);

    @NotNull
    default public S writeUTF\u0394(CharSequence cs) throws BufferOverflowException {
        BytesUtil.writeUTF(this, cs);
        return (S)this;
    }

    default public S write8bit(CharSequence cs) {
        BytesUtil.write8bit(this, cs);
        return (S)this;
    }

    default public S write8bit(@NotNull BytesStore sdi) {
        BytesUtil.write8bit(this, sdi);
        return (S)this;
    }

    @NotNull
    public S writeByte(byte var1);

    @NotNull
    default public S writeUnsignedByte(int i) {
        return this.writeByte((byte)Maths.toUInt8((long)i));
    }

    @NotNull
    public S writeShort(short var1);

    @NotNull
    default public S writeUnsignedShort(int u16) {
        return this.writeShort((short)Maths.toUInt16((long)u16));
    }

    @NotNull
    public S writeInt(int var1);

    @NotNull
    default public S writeUnsignedInt(long i) {
        return this.writeInt((int)Maths.toUInt32((long)i));
    }

    @NotNull
    public S writeLong(long var1);

    @NotNull
    public S writeFloat(float var1);

    @NotNull
    public S writeDouble(double var1);

    @NotNull
    default public S write(@NotNull BytesStore bytes) {
        return this.write(bytes, bytes.readPosition(), bytes.readRemaining());
    }

    @NotNull
    default public S write(@NotNull BytesStore bytes, long offset, long length) {
        BytesUtil.write(bytes, offset, length, this);
        return (S)this;
    }

    @NotNull
    default public S write(@NotNull byte[] bytes) {
        return this.write(bytes, 0, bytes.length);
    }

    @NotNull
    public S write(byte[] var1, int var2, int var3);

    @NotNull
    public S write(ByteBuffer var1);

    @NotNull
    default public S writeBoolean(boolean flag) {
        return this.writeByte(flag ? (byte)89 : 0);
    }

    @NotNull
    public S writeOrderedInt(int var1);

    @NotNull
    public S writeOrderedLong(long var1);

    public void nativeWrite(long var1, long var3);

    default public <E extends Enum<E>> void writeEnum(E e) {
        this.write8bit(e.name());
    }
}

