/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.ByteBufferAccess;
import net.openhft.chronicle.bytes.BytesAccesses;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeAccess;
import net.openhft.chronicle.bytes.ReadAccess;
import net.openhft.chronicle.bytes.WriteAccess;

public interface Access<T>
extends ReadAccess<T>,
WriteAccess<T> {
    public static <T> Access<T> nativeAccess() {
        return NativeAccess.instance();
    }

    public static Access<ByteBuffer> checkedByteBufferAccess() {
        return ByteBufferAccess.INSTANCE;
    }

    public static <B extends BytesStore<B, U>, U> Access<B> checkedBytesStoreAccess() {
        return BytesAccesses.Full.INSTANCE;
    }

    public static <S, T> void copy(ReadAccess<S> sourceAccess, S source, long sourceOffset, WriteAccess<T> targetAccess, T target, long targetOffset, long len) {
        targetAccess.writeFrom(target, targetOffset, sourceAccess, source, sourceOffset, len);
    }

    public static <T, U> boolean compare(ReadAccess<T> access1, T handle1, long offset1, ReadAccess<U> access2, U handle2, long offset2, long len) {
        return access1.compareTo(handle1, offset1, access2, handle2, offset2, len);
    }

    default public boolean compareAndSwapInt(T handle, long offset, int expected, int value) {
        throw new UnsupportedOperationException();
    }

    default public boolean compareAndSwapLong(T handle, long offset, long expected, long value) {
        throw new UnsupportedOperationException();
    }
}

