/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;

public class VanillaBytes<Underlying>
extends AbstractBytes<Underlying>
implements Byteable<Underlying> {
    public static VanillaBytes<Void> vanillaBytes() {
        return new VanillaBytes<Void>(NoBytesStore.noBytesStore());
    }

    public VanillaBytes(@NotNull BytesStore bytesStore) {
        this(bytesStore, bytesStore.writePosition(), bytesStore.writeLimit());
    }

    public VanillaBytes(@NotNull BytesStore bytesStore, long writePosition, long writeLimit) {
        super(bytesStore, writePosition, writeLimit);
    }

    @Override
    public void bytesStore(BytesStore<Bytes<Underlying>, Underlying> byteStore, long offset, long length) {
        this.bytesStore(byteStore);
        this.readLimit(offset + length);
        this.writeLimit(offset + length);
        this.readPosition(offset);
    }

    private void bytesStore(@NotNull BytesStore<Bytes<Underlying>, Underlying> bytesStore) {
        BytesStore oldBS = this.bytesStore;
        this.bytesStore = bytesStore;
        oldBS.release();
        this.clear();
    }

    @Override
    public long maxSize() {
        return this.readRemaining();
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    public Bytes<Underlying> bytesForRead() {
        return this.isClear() ? new VanillaBytes<Underlying>(this.bytesStore, this.bytesStore.writeLimit(), this.bytesStore.writeLimit()) : new SubBytes(this.bytesStore, this.readPosition(), this.readLimit());
    }

    @Override
    public long realCapacity() {
        return this.bytesStore.realCapacity();
    }

    @Override
    public BytesStore<Bytes<Underlying>, Underlying> copy() {
        if (this.bytesStore.underlyingObject() instanceof ByteBuffer) {
            ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.readRemaining()));
            ByteBuffer bbu = (ByteBuffer)this.bytesStore.underlyingObject();
            ByteBuffer slice = bbu.slice();
            slice.position((int)this.readPosition());
            slice.limit((int)this.readLimit());
            bb.put(slice);
            bb.clear();
            return BytesStore.wrap(bb);
        }
        return NativeBytes.copyOf(this);
    }

    @Override
    public Bytes<Underlying> write(BytesStore bytes, long offset, long length) {
        if (bytes.underlyingObject() == null && length >= 64L) {
            long len = Math.min(this.writeRemaining(), Math.min(bytes.readRemaining(), length));
            if (len > 0L) {
                this.writeCheckOffset(this.writePosition(), len);
                OS.memory().copyMemory(bytes.address(offset), this.address(this.writePosition()), len);
                this.writeSkip(len);
            }
        } else {
            super.write(bytes, offset, length);
        }
        return this;
    }

    @Override
    public NativeBytesStore bytesStore() {
        return (NativeBytesStore)this.bytesStore;
    }

    @Override
    public boolean equalBytes(BytesStore b, long remaining) {
        if (b instanceof VanillaBytes) {
            long i;
            VanillaBytes b2 = (VanillaBytes)b;
            NativeBytesStore nbs0 = this.bytesStore();
            NativeBytesStore nbs2 = b2.bytesStore();
            for (i = 0L; i < remaining - 7L; ++i) {
                long l2;
                long addr0 = nbs0.address + this.readPosition() - nbs0.start() + i;
                long addr2 = nbs2.address + b2.readPosition() - nbs2.start() + i;
                long l0 = NativeBytesStore.MEMORY.readLong(addr0);
                if (l0 == (l2 = NativeBytesStore.MEMORY.readLong(addr2))) continue;
                return false;
            }
            while (i < remaining) {
                byte b1;
                long offset2 = this.readPosition() + i - nbs0.start();
                long offset21 = b2.readPosition() + i - nbs2.start();
                byte b0 = NativeBytesStore.MEMORY.readByte(nbs0.address + offset2);
                if (b0 != (b1 = NativeBytesStore.MEMORY.readByte(nbs2.address + offset21))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equalBytes(b, remaining);
    }

    public void read8Bit(char[] chars, int length) {
        long position = this.readPosition();
        NativeBytesStore nbs = this.bytesStore();
        nbs.read8bit(position, chars, length);
    }

    @Override
    public int byteCheckSum() {
        if (this.readLimit() >= Integer.MAX_VALUE || this.start() != 0L) {
            return super.byteCheckSum();
        }
        int b = 0;
        NativeBytesStore bytesStore = this.bytesStore();
        int lim = (int)this.readLimit();
        for (int i = (int)this.readPosition(); i < lim; ++i) {
            b = (byte)(b + NativeBytesStore.MEMORY.readByte(bytesStore.address + (long)i));
        }
        return b & 0xFF;
    }
}

