/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.AccessCommon;
import net.openhft.chronicle.bytes.ReadAccess;
import net.openhft.chronicle.core.Maths;

public interface WriteAccess<T>
extends AccessCommon<T> {
    default public void writeByte(T handle, long offset, int i) {
        this.writeByte(handle, offset, Maths.toInt8((long)i));
    }

    default public void writeUnsignedByte(T handle, long offset, int i) {
        this.writeByte(handle, offset, (byte)Maths.toUInt8((long)i));
    }

    default public void writeBoolean(T handle, long offset, boolean flag) {
        this.writeByte(handle, offset, flag ? 89 : 0);
    }

    default public void writeUnsignedShort(T handle, long offset, int i) {
        this.writeShort(handle, offset, (short)Maths.toUInt16((long)i));
    }

    default public void writeChar(T handle, long offset, char c) {
        this.writeShort(handle, offset, (short)c);
    }

    default public void writeUnsignedInt(T handle, long offset, long i) {
        this.writeInt(handle, offset, (int)Maths.toUInt32((long)i));
    }

    public void writeByte(T var1, long var2, byte var4);

    public void writeShort(T var1, long var2, short var4);

    public void writeInt(T var1, long var2, int var4);

    default public void writeOrderedInt(T handle, long offset, int i) {
        throw new UnsupportedOperationException();
    }

    public void writeLong(T var1, long var2, long var4);

    default public void writeOrderedLong(T handle, long offset, long i) {
        throw new UnsupportedOperationException();
    }

    public void writeFloat(T var1, long var2, float var4);

    public void writeDouble(T var1, long var2, double var4);

    @Deprecated
    default public <S> void writeFrom(T handle, long offset, ReadAccess<S> sourceAccess, S source, long sourceOffset, long len) {
        long i = 0L;
        while (len - i >= 8L) {
            this.writeLong(handle, offset + i, sourceAccess.readLong(source, sourceOffset + i));
            i += 8L;
        }
        if (len - i >= 4L) {
            this.writeInt(handle, offset + i, sourceAccess.readInt(source, sourceOffset + i));
            i += 4L;
        }
        if (len - i >= 2L) {
            this.writeShort(handle, offset + i, sourceAccess.readShort(source, sourceOffset + i));
            i += 2L;
        }
        if (i < len) {
            this.writeByte(handle, offset + i, sourceAccess.readByte(source, sourceOffset + i));
        }
    }

    default public void writeBytes(T handle, long offset, long len, byte b) {
        long l;
        int i;
        char c;
        switch (b) {
            case 0: {
                this.zeroOut(handle, offset, len);
                return;
            }
            case -1: {
                c = '\uffff';
                i = -1;
                l = -1L;
                break;
            }
            default: {
                int ub = b & 0xFF;
                int ic = ub | ub << 8;
                c = (char)ic;
                i = ic | ic << 16;
                long ui = (long)i & 0xFFFFFFFFL;
                l = ui | ui << 32;
            }
        }
        long index = 0L;
        while (len - index >= 8L) {
            this.writeLong(handle, offset + index, l);
            index += 8L;
        }
        if (len - index >= 4L) {
            this.writeInt(handle, offset + index, i);
            index += 4L;
        }
        if (len - index >= 2L) {
            this.writeChar(handle, offset + index, c);
            index += 2L;
        }
        if (index < len) {
            this.writeByte(handle, offset + index, b);
        }
    }

    default public void zeroOut(T handle, long offset, long len) {
        long index = 0L;
        while (len - index >= 8L) {
            this.writeLong(handle, offset + index, 0L);
            index += 8L;
        }
        if (len - index >= 4L) {
            this.writeInt(handle, offset + index, 0);
            index += 4L;
        }
        if (len - index >= 2L) {
            this.writeChar(handle, offset + index, '\u0000');
            index += 2L;
        }
        if (index < len) {
            this.writeByte(handle, offset + index, (byte)0);
        }
    }
}

