/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bytes;

import java.nio.ByteBuffer;
import net.openhft.chronicle.algo.bytes.ByteBufferAccess;
import net.openhft.chronicle.algo.bytes.BytesAccesses;
import net.openhft.chronicle.algo.bytes.NativeAccess;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.bytes.WriteAccess;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;

public interface Access<T>
extends ReadAccess<T>,
WriteAccess<T> {
    public static <T> Access<T> nativeAccess() {
        return NativeAccess.instance();
    }

    public static Access<ByteBuffer> checkedByteBufferAccess() {
        return ByteBufferAccess.INSTANCE;
    }

    public static <B extends BytesStore<B, U>, U> Access<B> checkedBytesStoreAccess() {
        return BytesAccesses.Full.INSTANCE;
    }

    public static ReadAccess<RandomDataInput> checkedRandomDataInputAccess() {
        return BytesAccesses.RandomDataInputReadAccessEnum.INSTANCE;
    }

    public static <S, T> void copy(ReadAccess<S> sourceAccess, S source, long sourceOffset, WriteAccess<T> targetAccess, T target, long targetOffset, long len) {
        if (targetAccess == sourceAccess && target == source && targetOffset == sourceOffset) {
            return;
        }
        long i = 0L;
        while (len - i >= 8L) {
            targetAccess.writeLong(target, targetOffset + i, sourceAccess.readLong(source, sourceOffset + i));
            i += 8L;
        }
        if (len - i >= 4L) {
            targetAccess.writeInt(target, targetOffset + i, sourceAccess.readInt(source, sourceOffset + i));
            i += 4L;
        }
        if (len - i >= 2L) {
            targetAccess.writeShort(target, targetOffset + i, sourceAccess.readShort(source, sourceOffset + i));
            i += 2L;
        }
        if (i < len) {
            targetAccess.writeByte(target, targetOffset + i, sourceAccess.readByte(source, sourceOffset + i));
        }
    }

    public static <T, U> boolean equivalent(ReadAccess<T> access1, T handle1, long offset1, ReadAccess<U> access2, U handle2, long offset2, long len) {
        long i = 0L;
        while (len - i >= 8L) {
            if (access1.readLong(handle1, offset1 + i) != access2.readLong(handle2, offset2 + i)) {
                return false;
            }
            i += 8L;
        }
        if (len - i >= 4L) {
            if (access1.readInt(handle1, offset1 + i) != access2.readInt(handle2, offset2 + i)) {
                return false;
            }
            i += 4L;
        }
        if (len - i >= 2L) {
            if (access1.readShort(handle1, offset1 + i) != access2.readShort(handle2, offset2 + i)) {
                return false;
            }
            i += 2L;
        }
        if (i < len) {
            return access1.readByte(handle1, offset1 + i) == access2.readByte(handle2, offset2 + i);
        }
        return true;
    }

    public boolean compareAndSwapInt(T var1, long var2, int var4, int var5);

    public boolean compareAndSwapLong(T var1, long var2, long var4, long var6);
}

