/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bytes;

import java.nio.ByteOrder;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.core.UnsafeMemory;

public final class NativeAccess<T>
implements Access<T> {
    private static final NativeAccess<Object> INSTANCE = new NativeAccess();

    private NativeAccess() {
    }

    public static <T> NativeAccess<T> instance() {
        return INSTANCE;
    }

    @Override
    public byte readByte(T handle, long offset) {
        return UnsafeMemory.MEMORY.readByte(handle, offset);
    }

    @Override
    public short readShort(T handle, long offset) {
        return UnsafeMemory.MEMORY.readShort(handle, offset);
    }

    @Override
    public char readChar(T handle, long offset) {
        return (char)UnsafeMemory.MEMORY.readShort(handle, offset);
    }

    @Override
    public int readInt(T handle, long offset) {
        return UnsafeMemory.MEMORY.readInt(handle, offset);
    }

    @Override
    public long readLong(T handle, long offset) {
        return UnsafeMemory.MEMORY.readLong(handle, offset);
    }

    @Override
    public float readFloat(T handle, long offset) {
        return UnsafeMemory.MEMORY.readFloat(handle, offset);
    }

    @Override
    public double readDouble(T handle, long offset) {
        return UnsafeMemory.MEMORY.readDouble(handle, offset);
    }

    @Override
    public int readVolatileInt(T handle, long offset) {
        return UnsafeMemory.MEMORY.readVolatileInt(handle, offset);
    }

    @Override
    public long readVolatileLong(T handle, long offset) {
        return UnsafeMemory.MEMORY.readVolatileLong(handle, offset);
    }

    @Override
    public void writeByte(T handle, long offset, byte i8) {
        UnsafeMemory.MEMORY.writeByte(handle, offset, i8);
    }

    @Override
    public void writeShort(T handle, long offset, short i) {
        UnsafeMemory.MEMORY.writeShort(handle, offset, i);
    }

    @Override
    public void writeChar(T handle, long offset, char c) {
        UnsafeMemory.MEMORY.writeShort(handle, offset, (short)c);
    }

    @Override
    public void writeInt(T handle, long offset, int i) {
        UnsafeMemory.MEMORY.writeInt(handle, offset, i);
    }

    @Override
    public void writeOrderedInt(T handle, long offset, int i) {
        UnsafeMemory.MEMORY.writeOrderedInt(handle, offset, i);
    }

    @Override
    public void writeLong(T handle, long offset, long i) {
        UnsafeMemory.MEMORY.writeLong(handle, offset, i);
    }

    @Override
    public void writeOrderedLong(T handle, long offset, long i) {
        UnsafeMemory.MEMORY.writeOrderedLong(handle, offset, i);
    }

    @Override
    public void writeFloat(T handle, long offset, float d) {
        UnsafeMemory.MEMORY.writeFloat(handle, offset, d);
    }

    @Override
    public void writeDouble(T handle, long offset, double d) {
        UnsafeMemory.MEMORY.writeDouble(handle, offset, d);
    }

    @Override
    public boolean compareAndSwapInt(T handle, long offset, int expected, int value) {
        return UnsafeMemory.MEMORY.compareAndSwapInt(handle, offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(T handle, long offset, long expected, long value) {
        return UnsafeMemory.MEMORY.compareAndSwapLong(handle, offset, expected, value);
    }

    @Override
    public ByteOrder byteOrder(T handle) {
        return ByteOrder.nativeOrder();
    }

    @Override
    public void writeBytes(T handle, long offset, long len, byte b) {
        UnsafeMemory.MEMORY.setMemory(handle, offset, len, b);
    }

    @Override
    public void zeroOut(T handle, long offset, long len) {
        UnsafeMemory.MEMORY.setMemory(handle, offset, len, (byte)0);
    }
}

