/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bitset;

import net.openhft.chronicle.algo.MemoryUnit;
import net.openhft.chronicle.algo.bitset.BitSetAlgorithm;
import net.openhft.chronicle.algo.bitset.BitSetFrame;
import net.openhft.chronicle.algo.bitset.FlatBitSetAlgorithm;
import net.openhft.chronicle.algo.bitset.SingleThreadedFlatBitSetFrame;
import net.openhft.chronicle.algo.bytes.Access;

public final class ConcurrentFlatBitSetFrame
implements BitSetFrame {
    private final long longLength;

    public ConcurrentFlatBitSetFrame(long logicalSize) {
        this.longLength = MemoryUnit.BITS.toLongs(logicalSize);
    }

    private static long rightShiftOneFill(long l, long shift) {
        return l >> (int)shift | -1L >>> (int)shift ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private static long leftShiftOneFill(long l, long shift) {
        return l << (int)shift | (1L << (int)shift) - 1L;
    }

    private <T> long readLong(Access<T> access, T handle, long offset, long longIndex) {
        return access.readLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex));
    }

    private <T> long readVolatileLong(Access<T> access, T handle, long offset, long longIndex) {
        return access.readVolatileLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex));
    }

    private boolean checkIndex(long bitIndex) {
        if (bitIndex < 0L || bitIndex >> 6 >= this.longLength) {
            throw new IndexOutOfBoundsException("index: " + bitIndex + ", logical size: " + MemoryUnit.LONGS.toBits(this.longLength));
        }
        return true;
    }

    private boolean checkFromTo(long fromIndex, long exclusiveToIndex, long toLongIndex) {
        if (fromIndex < 0L || fromIndex > exclusiveToIndex || toLongIndex >= this.longLength) {
            throw new IndexOutOfBoundsException("index range: [" + fromIndex + ", " + exclusiveToIndex + "), logical size: " + MemoryUnit.LONGS.toBits(this.longLength));
        }
        return true;
    }

    @Override
    public <T> void flip(Access<T> access, T handle, long offset, long bitIndex) {
        long l2;
        long l;
        assert (this.checkIndex(bitIndex));
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        while (!access.compareAndSwapLong(handle, byteIndex, l = access.readVolatileLong(handle, byteIndex), l2 = l ^ mask)) {
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <T> void flipRange(Access<T> access, T handle, long offset, long fromIndex, long exclusiveToIndex) {
        long l2;
        long l;
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(toIndex);
        assert (this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex));
        if (fromLongIndex != toLongIndex) {
            long l22;
            long l3;
            long i;
            long l23;
            long l4;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
                mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex);
                while (!access.compareAndSwapLong(handle, fromByteIndex, l4 = access.readVolatileLong(handle, fromByteIndex), l23 = l4 ^ mask)) {
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                i = firstFullLongIndex;
                while (true) {
                    if (i > toLongIndex) {
                        return;
                    }
                    do {
                        l3 = this.readVolatileLong(access, handle, offset, i);
                        l22 = l3 ^ 0xFFFFFFFFFFFFFFFFL;
                    } while (!access.compareAndSwapLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, i), l3, l22));
                    ++i;
                }
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                do {
                    l3 = this.readVolatileLong(access, handle, offset, i);
                    l22 = l3 ^ 0xFFFFFFFFFFFFFFFFL;
                } while (!access.compareAndSwapLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, i), l3, l22));
            }
            long toByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, toLongIndex);
            mask = SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
            while (!access.compareAndSwapLong(handle, toByteIndex, l4 = access.readVolatileLong(handle, toByteIndex), l23 = l4 ^ mask)) {
            }
            return;
        }
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
        long mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex) & SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
        while (!access.compareAndSwapLong(handle, byteIndex, l = access.readVolatileLong(handle, byteIndex), l2 = l ^ mask)) {
        }
    }

    @Override
    public <T> void set(Access<T> access, T handle, long offset, long bitIndex) {
        long l2;
        long l;
        assert (this.checkIndex(bitIndex));
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        do {
            if (((l = access.readVolatileLong(handle, byteIndex)) & mask) == 0L) continue;
            return;
        } while (!access.compareAndSwapLong(handle, byteIndex, l, l2 = l | mask));
    }

    @Override
    public <T> boolean setIfClear(Access<T> access, T handle, long offset, long bitIndex) {
        long l2;
        long l;
        assert (this.checkIndex(bitIndex));
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        do {
            if ((l = access.readVolatileLong(handle, byteIndex)) != (l2 = l | mask)) continue;
            return false;
        } while (!access.compareAndSwapLong(handle, byteIndex, l, l2));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <T> void setRange(Access<T> access, T handle, long offset, long fromIndex, long exclusiveToIndex) {
        long l2;
        long l;
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(toIndex);
        assert (this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex));
        if (fromLongIndex != toLongIndex) {
            long i;
            long l22;
            long l3;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
                mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex);
                while (!access.compareAndSwapLong(handle, fromByteIndex, l3 = access.readVolatileLong(handle, fromByteIndex), l22 = l3 | mask)) {
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                i = firstFullLongIndex;
                while (true) {
                    if (i > toLongIndex) {
                        return;
                    }
                    access.writeOrderedLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, i), -1L);
                    ++i;
                }
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                access.writeOrderedLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, i), -1L);
            }
            long toByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, toLongIndex);
            mask = SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
            while (!access.compareAndSwapLong(handle, toByteIndex, l3 = access.readVolatileLong(handle, toByteIndex), l22 = l3 | mask)) {
            }
            return;
        }
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
        long mask = SingleThreadedFlatBitSetFrame.higherBitsIncludingThis(fromIndex) & SingleThreadedFlatBitSetFrame.lowerBitsIncludingThis(toIndex);
        while (!access.compareAndSwapLong(handle, byteIndex, l = access.readVolatileLong(handle, byteIndex), l2 = l | mask)) {
        }
    }

    @Override
    public <T> void setAll(Access<T> access, T handle, long offset) {
        for (long i = 0L; i < this.longLength; ++i) {
            access.writeOrderedLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, i), -1L);
        }
    }

    @Override
    public <T> void clear(Access<T> access, T handle, long offset, long bitIndex) {
        long l2;
        long l;
        assert (this.checkIndex(bitIndex));
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        do {
            if (((l = access.readVolatileLong(handle, byteIndex)) & mask) != 0L) continue;
            return;
        } while (!access.compareAndSwapLong(handle, byteIndex, l, l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
    }

    @Override
    public <T> boolean clearIfSet(Access<T> access, T handle, long offset, long bitIndex) {
        long l2;
        long l;
        assert (this.checkIndex(bitIndex));
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex);
        long mask = SingleThreadedFlatBitSetFrame.singleBit(bitIndex);
        do {
            if (((l = access.readVolatileLong(handle, byteIndex)) & mask) != 0L) continue;
            return false;
        } while (!access.compareAndSwapLong(handle, byteIndex, l, l2 = l & (mask ^ 0xFFFFFFFFFFFFFFFFL)));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public <T> void clearRange(Access<T> access, T handle, long offset, long fromIndex, long exclusiveToIndex) {
        long l2;
        long l;
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        long toIndex = exclusiveToIndex - 1L;
        long toLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(toIndex);
        assert (this.checkFromTo(fromIndex, exclusiveToIndex, toLongIndex));
        if (fromLongIndex != toLongIndex) {
            long i;
            long l22;
            long l3;
            long mask;
            long firstFullLongIndex = fromLongIndex;
            if ((fromIndex & 0x3FL) != 0L) {
                long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
                mask = SingleThreadedFlatBitSetFrame.lowerBitsExcludingThis(fromIndex);
                while (!access.compareAndSwapLong(handle, fromByteIndex, l3 = access.readVolatileLong(handle, fromByteIndex), l22 = l3 & mask)) {
                }
                ++firstFullLongIndex;
            }
            if ((exclusiveToIndex & 0x3FL) == 0L) {
                i = firstFullLongIndex;
                while (true) {
                    if (i > toLongIndex) {
                        return;
                    }
                    access.writeOrderedLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, i), 0L);
                    ++i;
                }
            }
            for (i = firstFullLongIndex; i < toLongIndex; ++i) {
                access.writeOrderedLong(handle, SingleThreadedFlatBitSetFrame.firstByte(offset, i), 0L);
            }
            long toByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, toLongIndex);
            mask = SingleThreadedFlatBitSetFrame.higherBitsExcludingThis(toIndex);
            while (!access.compareAndSwapLong(handle, toByteIndex, l3 = access.readVolatileLong(handle, toByteIndex), l22 = l3 & mask)) {
            }
            return;
        }
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
        long mask = SingleThreadedFlatBitSetFrame.lowerBitsExcludingThis(fromIndex) | SingleThreadedFlatBitSetFrame.higherBitsExcludingThis(toIndex);
        while (!access.compareAndSwapLong(handle, byteIndex, l = access.readVolatileLong(handle, byteIndex), l2 = l & mask)) {
        }
    }

    @Override
    public <T> void clearAll(Access<T> access, T handle, long offset) {
        access.writeBytes(handle, offset, MemoryUnit.LONGS.toBytes(this.longLength), (byte)0);
    }

    @Override
    public <T> boolean get(Access<T> access, T handle, long offset, long bitIndex) {
        assert (this.checkIndex(bitIndex));
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        long l = this.readVolatileLong(access, handle, offset, longIndex);
        return (l & SingleThreadedFlatBitSetFrame.singleBit(bitIndex)) != 0L;
    }

    @Override
    public <T> boolean isRangeSet(Access<T> access, T handle, long offset, long fromIndex, long toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> boolean isRangeClear(Access<T> access, T handle, long offset, long fromIndex, long toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> long nextSetBit(Access<T> access, T handle, long offset, long fromIndex) {
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = this.readVolatileLong(access, handle, offset, fromLongIndex) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.readLong(access, handle, offset, i);
            if (l == 0L) continue;
            return SingleThreadedFlatBitSetFrame.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public BitSetFrame.Bits setBits() {
        return new SetBits();
    }

    @Override
    public BitSetAlgorithm algorithm() {
        return FlatBitSetAlgorithm.INSTANCE;
    }

    @Override
    public <T> long clearNextSetBit(Access<T> access, T handle, long offset, long fromIndex) {
        long w;
        long l;
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
        while ((l = (w = access.readVolatileLong(handle, fromByteIndex)) >>> (int)fromIndex) != 0L) {
            long indexOfSetBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfSetBit);
            if (!access.compareAndSwapLong(handle, fromByteIndex, w, w ^ mask)) continue;
            return indexOfSetBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long l2;
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, i);
            while ((l2 = access.readLong(handle, byteIndex)) != 0L) {
                long indexOfSetBit = SingleThreadedFlatBitSetFrame.firstBit(i) + (long)Long.numberOfTrailingZeros(l2);
                long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfSetBit);
                if (!access.compareAndSwapLong(handle, byteIndex, l2, l2 ^ mask)) continue;
                return indexOfSetBit;
            }
        }
        return -1L;
    }

    @Override
    public <T> long nextClearBit(Access<T> access, T handle, long offset, long fromIndex) {
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long l = (this.readVolatileLong(access, handle, offset, fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex;
        if (l != 0L) {
            return fromIndex + (long)Long.numberOfTrailingZeros(l);
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            l = this.readLong(access, handle, offset, i) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return SingleThreadedFlatBitSetFrame.firstBit(i) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    @Override
    public <T> long setNextClearBit(Access<T> access, T handle, long offset, long fromIndex) {
        long w;
        long l;
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            return -1L;
        }
        long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
        while ((l = ((w = access.readVolatileLong(handle, fromByteIndex)) ^ 0xFFFFFFFFFFFFFFFFL) >>> (int)fromIndex) != 0L) {
            long indexOfClearBit = fromIndex + (long)Long.numberOfTrailingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfClearBit);
            if (!access.compareAndSwapLong(handle, fromByteIndex, w, w ^ mask)) continue;
            return indexOfClearBit;
        }
        for (long i = fromLongIndex + 1L; i < this.longLength; ++i) {
            long w2;
            long l2;
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, i);
            while ((l2 = (w2 = access.readLong(handle, byteIndex)) ^ 0xFFFFFFFFFFFFFFFFL) != 0L) {
                long indexOfClearBit = SingleThreadedFlatBitSetFrame.firstBit(i) + (long)Long.numberOfTrailingZeros(l2);
                long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfClearBit);
                if (!access.compareAndSwapLong(handle, byteIndex, w2, w2 ^ mask)) continue;
                return indexOfClearBit;
            }
        }
        return -1L;
    }

    @Override
    public <T> long previousSetBit(Access<T> access, T handle, long offset, long fromIndex) {
        long l;
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.logicalSize() - 1L;
        }
        if ((l = this.readVolatileLong(access, handle, offset, fromLongIndex) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.readLong(access, handle, offset, i);
            if (l == 0L) continue;
            return SingleThreadedFlatBitSetFrame.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public <T> long clearPreviousSetBit(Access<T> access, T handle, long offset, long fromIndex) {
        long w;
        long l;
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.logicalSize() - 1L;
        }
        long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
        while ((l = (w = access.readVolatileLong(handle, fromByteIndex)) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfSetBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfSetBit);
            if (!access.compareAndSwapLong(handle, fromByteIndex, w, w ^ mask)) continue;
            return indexOfSetBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long l2;
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, i);
            while ((l2 = access.readLong(handle, byteIndex)) != 0L) {
                long indexOfSetBit = SingleThreadedFlatBitSetFrame.lastBit(i) - (long)Long.numberOfLeadingZeros(l2);
                long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfSetBit);
                if (!access.compareAndSwapLong(handle, byteIndex, l2, l2 ^ mask)) continue;
                return indexOfSetBit;
            }
        }
        return -1L;
    }

    @Override
    public <T> long previousClearBit(Access<T> access, T handle, long offset, long fromIndex) {
        long l;
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.logicalSize() - 1L;
        }
        if ((l = (this.readVolatileLong(access, handle, offset, fromLongIndex) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return fromIndex - (long)Long.numberOfLeadingZeros(l);
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            l = this.readLong(access, handle, offset, i) ^ 0xFFFFFFFFFFFFFFFFL;
            if (l == 0L) continue;
            return SingleThreadedFlatBitSetFrame.lastBit(i) - (long)Long.numberOfLeadingZeros(l);
        }
        return -1L;
    }

    @Override
    public <T> long setPreviousClearBit(Access<T> access, T handle, long offset, long fromIndex) {
        long w;
        long l;
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        long fromLongIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(fromIndex);
        if (fromLongIndex >= this.longLength) {
            fromLongIndex = this.longLength - 1L;
            fromIndex = this.logicalSize() - 1L;
        }
        long fromByteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, fromLongIndex);
        while ((l = ((w = access.readVolatileLong(handle, fromByteIndex)) ^ 0xFFFFFFFFFFFFFFFFL) << (int)(fromIndex ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            long indexOfClearBit = fromIndex - (long)Long.numberOfLeadingZeros(l);
            long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfClearBit);
            if (!access.compareAndSwapLong(handle, fromByteIndex, w, w ^ mask)) continue;
            return indexOfClearBit;
        }
        for (long i = fromLongIndex - 1L; i >= 0L; --i) {
            long w2;
            long l2;
            long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, i);
            while ((l2 = (w2 = access.readLong(handle, byteIndex)) ^ 0xFFFFFFFFFFFFFFFFL) != 0L) {
                long indexOfClearBit = SingleThreadedFlatBitSetFrame.lastBit(i) - (long)Long.numberOfLeadingZeros(l2);
                long mask = SingleThreadedFlatBitSetFrame.singleBit(indexOfClearBit);
                if (!access.compareAndSwapLong(handle, byteIndex, w2, w2 ^ mask)) continue;
                return indexOfClearBit;
            }
        }
        return -1L;
    }

    @Override
    public long logicalSize() {
        return MemoryUnit.LONGS.toBits(this.longLength);
    }

    @Override
    public long sizeInBytes() {
        return MemoryUnit.LONGS.toBytes(this.longLength);
    }

    @Override
    public <T> long cardinality(Access<T> access, T handle, long offset) {
        long count = Long.bitCount(access.readVolatileLong(handle, 0L));
        for (long i = 1L; i < this.longLength; ++i) {
            count += (long)Long.bitCount(this.readLong(access, handle, offset, i));
        }
        return count;
    }

    @Override
    public <T> long setNextNContinuousClearBits(Access<T> access, T handle, long offset, long fromIndex, int numberOfBits) {
        long l;
        long w;
        SingleThreadedFlatBitSetFrame.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.setNextClearBit(access, handle, offset, fromIndex);
        }
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        int n64Complement = 64 - numberOfBits;
        long nTrailingOnes = -1L >>> n64Complement;
        long bitIndex = fromIndex;
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex);
        if ((bitIndex & 0x3FL) > (long)n64Complement) {
            if (++longIndex >= this.longLength) {
                return -1L;
            }
            bitIndex = SingleThreadedFlatBitSetFrame.firstBit(longIndex);
            l = w = access.readVolatileLong(handle, byteIndex += 8L);
        } else {
            if (longIndex >= this.longLength) {
                return -1L;
            }
            w = access.readVolatileLong(handle, byteIndex);
            l = ConcurrentFlatBitSetFrame.rightShiftOneFill(w, bitIndex);
        }
        while (true) {
            block14: {
                block13: {
                    int trailingOnes;
                    if ((l & 1L) == 0L) break block13;
                    long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                    if (x == 0L || ((bitIndex += (long)(trailingOnes = Long.numberOfTrailingZeros(x))) & 0x3FL) > (long)n64Complement) break block14;
                    l = ConcurrentFlatBitSetFrame.rightShiftOneFill(l, trailingOnes);
                }
                while (true) {
                    int trailingOnes;
                    if ((l & nTrailingOnes) == 0L) {
                        long mask = nTrailingOnes << (int)bitIndex;
                        if (access.compareAndSwapLong(handle, byteIndex, w, w ^ mask)) {
                            return bitIndex;
                        }
                        w = access.readLong(handle, byteIndex);
                        l = ConcurrentFlatBitSetFrame.rightShiftOneFill(w, bitIndex);
                        continue;
                    }
                    int trailingZeros = Long.numberOfTrailingZeros(l);
                    bitIndex += (long)trailingZeros;
                    long x = (l = ConcurrentFlatBitSetFrame.rightShiftOneFill(l, trailingZeros)) ^ 0xFFFFFFFFFFFFFFFFL;
                    if (x == 0L || ((bitIndex += (long)(trailingOnes = Long.numberOfTrailingZeros(x))) & 0x3FL) > (long)n64Complement) break;
                    l >>= trailingOnes;
                }
            }
            if (++longIndex >= this.longLength) {
                return -1L;
            }
            bitIndex = SingleThreadedFlatBitSetFrame.firstBit(longIndex);
            l = w = access.readLong(handle, byteIndex += 8L);
        }
    }

    @Override
    public <T> long clearNextNContinuousSetBits(Access<T> access, T handle, long offset, long fromIndex, int numberOfBits) {
        long l;
        long w;
        SingleThreadedFlatBitSetFrame.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.clearNextSetBit(access, handle, offset, fromIndex);
        }
        SingleThreadedFlatBitSetFrame.checkFromIndex(fromIndex);
        int n64Complement = 64 - numberOfBits;
        long nTrailingOnes = -1L >>> n64Complement;
        long bitIndex = fromIndex;
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex);
        if ((bitIndex & 0x3FL) > (long)n64Complement) {
            if (++longIndex >= this.longLength) {
                return -1L;
            }
            bitIndex = SingleThreadedFlatBitSetFrame.firstBit(longIndex);
            l = w = access.readVolatileLong(handle, byteIndex += 8L);
        } else {
            if (longIndex >= this.longLength) {
                return -1L;
            }
            w = access.readVolatileLong(handle, byteIndex);
            l = w >>> (int)bitIndex;
        }
        while (true) {
            block14: {
                block13: {
                    int trailingZeros;
                    if ((l & 1L) != 0L) break block13;
                    if (l == 0L || ((bitIndex += (long)(trailingZeros = Long.numberOfTrailingZeros(l))) & 0x3FL) > (long)n64Complement) break block14;
                    l >>>= trailingZeros;
                }
                while (true) {
                    int trailingZeros;
                    if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nTrailingOnes) == 0L) {
                        long mask = nTrailingOnes << (int)bitIndex;
                        if (access.compareAndSwapLong(handle, byteIndex, w, w ^ mask)) {
                            return bitIndex;
                        }
                        w = access.readLong(handle, byteIndex);
                        l = w >>> (int)bitIndex;
                        continue;
                    }
                    int trailingOnes = Long.numberOfTrailingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                    bitIndex += (long)trailingOnes;
                    if ((l >>>= trailingOnes) == 0L || ((bitIndex += (long)(trailingZeros = Long.numberOfTrailingZeros(l))) & 0x3FL) > (long)n64Complement) break;
                    l >>>= trailingZeros;
                }
            }
            if (++longIndex >= this.longLength) {
                return -1L;
            }
            bitIndex = SingleThreadedFlatBitSetFrame.firstBit(longIndex);
            l = w = access.readLong(handle, byteIndex += 8L);
        }
    }

    @Override
    public <T> long setPreviousNContinuousClearBits(Access<T> access, T handle, long offset, long fromIndex, int numberOfBits) {
        long l;
        long w;
        SingleThreadedFlatBitSetFrame.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.setPreviousClearBit(access, handle, offset, fromIndex);
        }
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        int numberOfBitsMinusOne = numberOfBits - 1;
        long nLeadingOnes = -1L << 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        if (longIndex >= this.longLength) {
            longIndex = this.longLength - 1L;
            bitIndex = SingleThreadedFlatBitSetFrame.lastBit(longIndex);
        }
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex);
        if ((bitIndex & 0x3FL) < (long)numberOfBitsMinusOne) {
            if (--longIndex < 0L) {
                return -1L;
            }
            bitIndex = SingleThreadedFlatBitSetFrame.lastBit(longIndex);
            l = w = access.readVolatileLong(handle, byteIndex -= 8L);
        } else {
            w = access.readVolatileLong(handle, byteIndex);
            l = ConcurrentFlatBitSetFrame.leftShiftOneFill(w, bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        }
        while (true) {
            block15: {
                block14: {
                    int leadingOnes;
                    if (l >= 0L) break block14;
                    long x = l ^ 0xFFFFFFFFFFFFFFFFL;
                    if (x == 0L || ((bitIndex -= (long)(leadingOnes = Long.numberOfLeadingZeros(x))) & 0x3FL) < (long)numberOfBitsMinusOne) break block15;
                    l = ConcurrentFlatBitSetFrame.leftShiftOneFill(l, leadingOnes);
                }
                while (true) {
                    int leadingOnes;
                    if ((l & nLeadingOnes) == 0L) {
                        long mask = nLeadingOnes >>> (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
                        if (access.compareAndSwapLong(handle, byteIndex, w, w ^ mask)) {
                            return bitIndex - (long)numberOfBitsMinusOne;
                        }
                        w = access.readLong(handle, byteIndex);
                        l = ConcurrentFlatBitSetFrame.leftShiftOneFill(w, bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
                        continue;
                    }
                    int leadingZeros = Long.numberOfLeadingZeros(l);
                    bitIndex -= (long)leadingZeros;
                    long x = (l = ConcurrentFlatBitSetFrame.leftShiftOneFill(l, leadingZeros)) ^ 0xFFFFFFFFFFFFFFFFL;
                    if (x == 0L || ((bitIndex -= (long)(leadingOnes = Long.numberOfLeadingZeros(x))) & 0x3FL) < (long)numberOfBitsMinusOne) break;
                    l = ConcurrentFlatBitSetFrame.leftShiftOneFill(l, leadingOnes);
                }
            }
            if (--longIndex < 0L) {
                return -1L;
            }
            bitIndex = SingleThreadedFlatBitSetFrame.lastBit(longIndex);
            l = w = access.readLong(handle, byteIndex -= 8L);
        }
    }

    @Override
    public <T> long clearPreviousNContinuousSetBits(Access<T> access, T handle, long offset, long fromIndex, int numberOfBits) {
        long l;
        long w;
        SingleThreadedFlatBitSetFrame.checkNumberOfBits(numberOfBits);
        if (numberOfBits == 1) {
            return this.clearPreviousSetBit(access, handle, offset, fromIndex);
        }
        if (SingleThreadedFlatBitSetFrame.checkNotFoundIndex(fromIndex)) {
            return -1L;
        }
        int numberOfBitsMinusOne = numberOfBits - 1;
        long nLeadingOnes = -1L << 64 - numberOfBits;
        long bitIndex = fromIndex;
        long longIndex = SingleThreadedFlatBitSetFrame.longWithThisBit(bitIndex);
        if (longIndex >= this.longLength) {
            longIndex = this.longLength - 1L;
            bitIndex = SingleThreadedFlatBitSetFrame.lastBit(longIndex);
        }
        long byteIndex = SingleThreadedFlatBitSetFrame.firstByte(offset, longIndex);
        if ((bitIndex & 0x3FL) < (long)numberOfBitsMinusOne) {
            if (--longIndex < 0L) {
                return -1L;
            }
            bitIndex = SingleThreadedFlatBitSetFrame.lastBit(longIndex);
            l = w = access.readVolatileLong(handle, byteIndex -= 8L);
        } else {
            w = access.readVolatileLong(handle, byteIndex);
            l = w << (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        }
        while (true) {
            block15: {
                block16: {
                    block14: {
                        if (l <= 0L) break block14;
                        int leadingZeros = Long.numberOfLeadingZeros(l);
                        if (((bitIndex -= (long)leadingZeros) & 0x3FL) < (long)numberOfBitsMinusOne) break block15;
                        l <<= leadingZeros;
                        break block16;
                    }
                    if (l == 0L) break block15;
                }
                while (true) {
                    int leadingZeros;
                    if (((l ^ 0xFFFFFFFFFFFFFFFFL) & nLeadingOnes) == 0L) {
                        long mask = nLeadingOnes >>> (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
                        if (access.compareAndSwapLong(handle, byteIndex, w, w ^ mask)) {
                            return bitIndex - (long)numberOfBitsMinusOne;
                        }
                        w = access.readLong(handle, byteIndex);
                        l = w << (int)(bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
                        continue;
                    }
                    int leadingOnes = Long.numberOfLeadingZeros(l ^ 0xFFFFFFFFFFFFFFFFL);
                    bitIndex -= (long)leadingOnes;
                    if ((l <<= leadingOnes) == 0L || ((bitIndex -= (long)(leadingZeros = Long.numberOfLeadingZeros(l))) & 0x3FL) < (long)numberOfBitsMinusOne) break;
                    l <<= leadingZeros;
                }
            }
            if (--longIndex < 0L) {
                return -1L;
            }
            bitIndex = SingleThreadedFlatBitSetFrame.lastBit(longIndex);
            l = w = access.readLong(handle, byteIndex -= 8L);
        }
    }

    private class SetBits
    implements BitSetFrame.Bits {
        private final long byteLength;
        private long byteIndex;
        private long bitIndex;

        private SetBits() {
            this.byteLength = ConcurrentFlatBitSetFrame.this.longLength << 3;
            this.byteIndex = 0L;
            this.bitIndex = 0L;
        }

        @Override
        public <T> BitSetFrame.Bits reset(Access<T> access, T handle, long offset) {
            this.byteIndex = 0L;
            this.bitIndex = 0L;
            return this;
        }

        @Override
        public <T> long next(Access<T> access, T handle, long offset) {
            long bitIndex = this.bitIndex;
            if (bitIndex >= 0L) {
                long i = this.byteIndex;
                long l = access.readVolatileLong(handle, i) >>> (int)bitIndex;
                if (l != 0L) {
                    int trailingZeros = Long.numberOfTrailingZeros(l);
                    long index = bitIndex + (long)trailingZeros;
                    this.bitIndex = index + 1L;
                    if ((this.bitIndex & 0x3FL) == 0L && (this.byteIndex = i + 8L) == this.byteLength) {
                        this.bitIndex = -1L;
                    }
                    return index;
                }
                long lim = this.byteLength;
                while ((i += 8L) < lim) {
                    l = access.readLong(handle, i);
                    if (l == 0L) continue;
                    int trailingZeros = Long.numberOfTrailingZeros(l);
                    long index = (i << 3) + (long)trailingZeros;
                    this.bitIndex = index + 1L;
                    if ((this.bitIndex & 0x3FL) != 0L) {
                        this.byteIndex = i;
                    } else {
                        this.byteIndex = i + 8L;
                        if (this.byteIndex == lim) {
                            this.bitIndex = -1L;
                        }
                    }
                    return index;
                }
            }
            this.bitIndex = -1L;
            return -1L;
        }
    }
}

