/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.hashing;

import java.nio.ByteOrder;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.algo.hashing.Primitives;

class CityHash_1_1 {
    private static final CityHash_1_1 INSTANCE = new CityHash_1_1();
    private static final CityHash_1_1 NATIVE_CITY = LongHashFunction.NATIVE_LITTLE_ENDIAN ? INSTANCE : BigEndian.access$000();
    private static final long K0 = -4348849565147123417L;
    private static final long K1 = -5435081209227447693L;
    private static final long K2 = -7286425919675154353L;
    private static final long K_MUL = -7070675565921424023L;

    private CityHash_1_1() {
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static long hashLen16(long u, long v) {
        return CityHash_1_1.hashLen16(u, v, -7070675565921424023L);
    }

    private static long hashLen16(long u, long v, long mul) {
        long a = CityHash_1_1.shiftMix((u ^ v) * mul);
        return CityHash_1_1.shiftMix((v ^ a) * mul) * mul;
    }

    private static long mul(long len) {
        return -7286425919675154353L + (len << 1);
    }

    private static long hash1To3Bytes(int len, int firstByte, int midOrLastByte, int lastByte) {
        int y = firstByte + (midOrLastByte << 8);
        int z = len + (lastByte << 2);
        return CityHash_1_1.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
    }

    private static long hash4To7Bytes(long len, long first4Bytes, long last4Bytes) {
        long mul = CityHash_1_1.mul(len);
        return CityHash_1_1.hashLen16(len + (first4Bytes << 3), last4Bytes, mul);
    }

    private static long hash8To16Bytes(long len, long first8Bytes, long last8Bytes) {
        long mul = CityHash_1_1.mul(len);
        long a = first8Bytes + -7286425919675154353L;
        long c = Long.rotateRight(last8Bytes, 37) * mul + a;
        long d = (Long.rotateRight(a, 25) + last8Bytes) * mul;
        return CityHash_1_1.hashLen16(c, d, mul);
    }

    public static LongHashFunction asLongHashFunctionWithoutSeed() {
        return AsLongHashFunction.INSTANCE;
    }

    public static LongHashFunction asLongHashFunctionWithSeed(long seed) {
        return new AsLongHashFunctionSeeded(-7286425919675154353L, seed);
    }

    public static LongHashFunction asLongHashFunctionWithTwoSeeds(long seed0, long seed1) {
        return new AsLongHashFunctionSeeded(seed0, seed1);
    }

    <T> long fetch64(ReadAccess<T> access, T in, long off) {
        return access.readLong(in, off);
    }

    <T> int fetch32(ReadAccess<T> access, T in, long off) {
        return access.readInt(in, off);
    }

    long toLittleEndian(long v) {
        return v;
    }

    int toLittleEndian(int v) {
        return v;
    }

    private <T> long hashLen0To16(ReadAccess<T> access, T in, long off, long len) {
        if (len >= 8L) {
            long a = this.fetch64(access, in, off);
            long b = this.fetch64(access, in, off + len - 8L);
            return CityHash_1_1.hash8To16Bytes(len, a, b);
        }
        if (len >= 4L) {
            long a = Primitives.unsignedInt(this.fetch32(access, in, off));
            long b = Primitives.unsignedInt(this.fetch32(access, in, off + len - 4L));
            return CityHash_1_1.hash4To7Bytes(len, a, b);
        }
        if (len > 0L) {
            int a = access.readUnsignedByte(in, off);
            int b = access.readUnsignedByte(in, off + (len >> 1));
            int c = access.readUnsignedByte(in, off + len - 1L);
            return CityHash_1_1.hash1To3Bytes((int)len, a, b, c);
        }
        return -7286425919675154353L;
    }

    private <T> long hashLen17To32(ReadAccess<T> access, T in, long off, long len) {
        long mul = CityHash_1_1.mul(len);
        long a = this.fetch64(access, in, off) * -5435081209227447693L;
        long b = this.fetch64(access, in, off + 8L);
        long c = this.fetch64(access, in, off + len - 8L) * mul;
        long d = this.fetch64(access, in, off + len - 16L) * -7286425919675154353L;
        return CityHash_1_1.hashLen16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private <T> long hashLen33To64(ReadAccess<T> access, T in, long off, long len) {
        long mul = CityHash_1_1.mul(len);
        long a = this.fetch64(access, in, off) * -7286425919675154353L;
        long b = this.fetch64(access, in, off + 8L);
        long c = this.fetch64(access, in, off + len - 24L);
        long d = this.fetch64(access, in, off + len - 32L);
        long e = this.fetch64(access, in, off + 16L) * -7286425919675154353L;
        long f = this.fetch64(access, in, off + 24L) * 9L;
        long g = this.fetch64(access, in, off + len - 8L);
        long h = this.fetch64(access, in, off + len - 16L) * mul;
        long u = Long.rotateRight(a + g, 43) + (Long.rotateRight(b, 30) + c) * 9L;
        long v = (a + g ^ d) + f + 1L;
        long w = Long.reverseBytes((u + v) * mul) + h;
        long x = Long.rotateRight(e + f, 42) + c;
        long y = (Long.reverseBytes((v + w) * mul) + g) * mul;
        long z = e + f + c;
        a = Long.reverseBytes((x + z) * mul + y) + b;
        b = CityHash_1_1.shiftMix((z + a) * mul + d + h) * mul;
        return b + x;
    }

    <T> long cityHash64(ReadAccess<T> access, T in, long off, long len) {
        if (len <= 32L) {
            if (len <= 16L) {
                return this.hashLen0To16(access, in, off, len);
            }
            return this.hashLen17To32(access, in, off, len);
        }
        if (len <= 64L) {
            return this.hashLen33To64(access, in, off, len);
        }
        long x = this.fetch64(access, in, off + len - 40L);
        long y = this.fetch64(access, in, off + len - 16L) + this.fetch64(access, in, off + len - 56L);
        long z = CityHash_1_1.hashLen16(this.fetch64(access, in, off + len - 48L) + len, this.fetch64(access, in, off + len - 24L));
        long a3 = len;
        long b3 = z;
        long w4 = this.fetch64(access, in, off + len - 64L);
        long x4 = this.fetch64(access, in, off + len - 64L + 8L);
        long y4 = this.fetch64(access, in, off + len - 64L + 16L);
        long z4 = this.fetch64(access, in, off + len - 64L + 24L);
        b3 = Long.rotateRight(b3 + (a3 += w4) + z4, 21);
        long c3 = a3;
        long vFirst = a3 + z4;
        long vSecond = (b3 += Long.rotateRight(a3 += x4 + y4, 44)) + c3;
        long a2 = y + -5435081209227447693L;
        long b2 = x;
        long w3 = this.fetch64(access, in, off + len - 32L);
        long x3 = this.fetch64(access, in, off + len - 32L + 8L);
        long y3 = this.fetch64(access, in, off + len - 32L + 16L);
        long z3 = this.fetch64(access, in, off + len - 32L + 24L);
        b2 = Long.rotateRight(b2 + (a2 += w3) + z3, 21);
        long c2 = a2;
        long wFirst = a2 + z3;
        long wSecond = (b2 += Long.rotateRight(a2 += x3 + y3, 44)) + c2;
        x = x * -5435081209227447693L + this.fetch64(access, in, off);
        len = len - 1L & 0xFFFFFFFFFFFFFFC0L;
        do {
            x = Long.rotateRight(x + y + vFirst + this.fetch64(access, in, off + 8L), 37) * -5435081209227447693L;
            y = Long.rotateRight(y + vSecond + this.fetch64(access, in, off + 48L), 42) * -5435081209227447693L;
            y += vFirst + this.fetch64(access, in, off + 40L);
            z = Long.rotateRight(z + wFirst, 33) * -5435081209227447693L;
            long a1 = vSecond * -5435081209227447693L;
            long b1 = (x ^= wSecond) + wFirst;
            long w2 = this.fetch64(access, in, off);
            long x2 = this.fetch64(access, in, off + 8L);
            long y2 = this.fetch64(access, in, off + 16L);
            long z2 = this.fetch64(access, in, off + 24L);
            b1 = Long.rotateRight(b1 + (a1 += w2) + z2, 21);
            long c1 = a1;
            vFirst = a1 + z2;
            vSecond = (b1 += Long.rotateRight(a1 += x2 + y2, 44)) + c1;
            long a = z + wSecond;
            long b = y + this.fetch64(access, in, off + 16L);
            long w1 = this.fetch64(access, in, off + 32L);
            long x1 = this.fetch64(access, in, off + 32L + 8L);
            long y1 = this.fetch64(access, in, off + 32L + 16L);
            long z1 = this.fetch64(access, in, off + 32L + 24L);
            b = Long.rotateRight(b + (a += w1) + z1, 21);
            long c = a;
            wFirst = a + z1;
            wSecond = (b += Long.rotateRight(a += x1 + y1, 44)) + c;
            long tmp = x;
            x = z;
            z = tmp;
            off += 64L;
        } while ((len -= 64L) != 0L);
        return CityHash_1_1.hashLen16(CityHash_1_1.hashLen16(vFirst, wFirst) + CityHash_1_1.shiftMix(y) * -5435081209227447693L + z, CityHash_1_1.hashLen16(vSecond, wSecond) + x);
    }

    private static class AsLongHashFunctionSeeded
    extends AsLongHashFunction {
        private static final long serialVersionUID = 0L;
        private final long seed0;
        private final long seed1;
        private transient long voidHash;

        private AsLongHashFunctionSeeded(long seed0, long seed1) {
            this.seed0 = seed0;
            this.seed1 = seed1;
            this.voidHash = this.finalizeHash(-7286425919675154353L);
        }

        @Override
        public long hashVoid() {
            return this.voidHash;
        }

        @Override
        protected final long finalizeHash(long hash) {
            return CityHash_1_1.hashLen16(hash - this.seed0, this.seed1);
        }
    }

    private static class AsLongHashFunction
    extends LongHashFunction {
        public static final AsLongHashFunction INSTANCE = new AsLongHashFunction();
        private static final long serialVersionUID = 0L;
        private static final int FIRST_SHORT_BYTE_SHIFT = NATIVE_LITTLE_ENDIAN ? 0 : 8;
        private static final int FIRST_SHORT_BYTE_MASK = NATIVE_LITTLE_ENDIAN ? 255 : -1;
        private static final int SECOND_SHORT_BYTE_SHIFT = 8 - FIRST_SHORT_BYTE_SHIFT;
        private static final int SECOND_SHORT_BYTE_MASK = NATIVE_LITTLE_ENDIAN ? -1 : 255;

        private AsLongHashFunction() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public long hashLong(long input) {
            input = NATIVE_CITY.toLittleEndian(input);
            long hash = CityHash_1_1.hash8To16Bytes(8L, input, input);
            return this.finalizeHash(hash);
        }

        @Override
        public long hashInt(int input) {
            input = NATIVE_CITY.toLittleEndian(input);
            long unsignedInt = Primitives.unsignedInt(input);
            long hash = CityHash_1_1.hash4To7Bytes(4L, unsignedInt, unsignedInt);
            return this.finalizeHash(hash);
        }

        @Override
        public long hashShort(short input) {
            return this.hashChar((char)input);
        }

        @Override
        public long hashChar(char input) {
            char unsignedInput = input;
            int firstByte = unsignedInput >> FIRST_SHORT_BYTE_SHIFT & FIRST_SHORT_BYTE_MASK;
            int secondByte = unsignedInput >> SECOND_SHORT_BYTE_SHIFT & SECOND_SHORT_BYTE_MASK;
            long hash = CityHash_1_1.hash1To3Bytes(2, firstByte, secondByte, secondByte);
            return this.finalizeHash(hash);
        }

        @Override
        public long hashByte(byte input) {
            int unsignedByte = Primitives.unsignedByte(input);
            long hash = CityHash_1_1.hash1To3Bytes(1, unsignedByte, unsignedByte, unsignedByte);
            return this.finalizeHash(hash);
        }

        @Override
        public long hashVoid() {
            return -7286425919675154353L;
        }

        @Override
        public <T> long hash(T input, ReadAccess<T> access, long off, long len) {
            long hash = access.byteOrder(input) == ByteOrder.LITTLE_ENDIAN ? INSTANCE.cityHash64(access, input, off, len) : BigEndian.INSTANCE.cityHash64(access, input, off, len);
            return this.finalizeHash(hash);
        }

        long finalizeHash(long hash) {
            return hash;
        }
    }

    private static class BigEndian
    extends CityHash_1_1 {
        private static final BigEndian INSTANCE = new BigEndian();

        private BigEndian() {
        }

        @Override
        <T> long fetch64(ReadAccess<T> access, T in, long off) {
            return Long.reverseBytes(super.fetch64(access, in, off));
        }

        @Override
        <T> int fetch32(ReadAccess<T> access, T in, long off) {
            return Integer.reverseBytes(super.fetch32(access, in, off));
        }

        @Override
        long toLittleEndian(long v) {
            return Long.reverseBytes(v);
        }

        @Override
        int toLittleEndian(int v) {
            return Integer.reverseBytes(v);
        }
    }
}

