/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import net.openhft.affinity.AffinityLock;
import net.openhft.affinity.BootClassPath;
import net.openhft.affinity.IAffinity;
import net.openhft.affinity.NonForkingAffinityLock;
import net.openhft.affinity.impl.LinuxJNAAffinity;
import net.openhft.affinity.impl.NullAffinity;
import net.openhft.affinity.impl.OSXJNAAffinity;
import net.openhft.affinity.impl.PosixJNAAffinity;
import net.openhft.affinity.impl.SolarisJNAAffinity;
import net.openhft.affinity.impl.WindowsJNAAffinity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AffinitySupport {

    @NotNull
    private static final IAffinity AFFINITY_IMPL;
    private static final Logger LOGGER;
    private static Boolean JNAAvailable;

    public static IAffinity getAffinityImpl() {
        return AFFINITY_IMPL;
    }

    private static boolean isWindowsJNAAffinityUsable() {
        if (AffinitySupport.isJNAAvailable()) {
            try {
                return WindowsJNAAffinity.LOADED;
            }
            catch (Throwable t) {
                AffinitySupport.logThrowable(t, "Windows JNA-based affinity not usable because it failed to load!");
                return false;
            }
        }
        LOGGER.warn("Windows JNA-based affinity not usable due to JNA not being available!");
        return false;
    }

    private static boolean isPosixJNAAffinityUsable() {
        if (AffinitySupport.isJNAAvailable()) {
            try {
                return PosixJNAAffinity.LOADED;
            }
            catch (Throwable t) {
                AffinitySupport.logThrowable(t, "Posix JNA-based affinity not usable because it failed to load!");
                return false;
            }
        }
        LOGGER.warn("Posix JNA-based affinity not usable due to JNA not being available!");
        return false;
    }

    private static boolean isLinuxJNAAffinityUsable() {
        if (AffinitySupport.isJNAAvailable()) {
            try {
                return LinuxJNAAffinity.LOADED;
            }
            catch (Throwable t) {
                AffinitySupport.logThrowable(t, "Linux JNA-based affinity not usable because it failed to load!");
                return false;
            }
        }
        LOGGER.warn("Linux JNA-based affinity not usable due to JNA not being available!");
        return false;
    }

    private static boolean isMacJNAAffinityUsable() {
        if (AffinitySupport.isJNAAvailable()) {
            return true;
        }
        LOGGER.warn("MAX OSX JNA-based affinity not usable due to JNA not being available!");
        return false;
    }

    private static boolean isSolarisJNAAffinityUsable() {
        if (AffinitySupport.isJNAAvailable()) {
            return true;
        }
        LOGGER.warn("Solaris JNA-based affinity not usable due to JNA not being available!");
        return false;
    }

    private static void logThrowable(Throwable t, String description) {
        StringWriter sw = new StringWriter();
        sw.append(description);
        sw.append(" Reason: ");
        t.printStackTrace(new PrintWriter(sw));
        LOGGER.warn(sw.toString());
    }

    public static long getAffinity() {
        return AFFINITY_IMPL.getAffinity();
    }

    public static void setAffinity(long affinity) {
        AFFINITY_IMPL.setAffinity(affinity);
    }

    public static int getCpu() {
        return AFFINITY_IMPL.getCpu();
    }

    public static int getThreadId() {
        return AFFINITY_IMPL.getThreadId();
    }

    public static boolean isJNAAvailable() {
        if (JNAAvailable == null) {
            try {
                Class.forName("com.sun.jna.Platform");
                JNAAvailable = true;
            }
            catch (ClassNotFoundException ignored) {
                JNAAvailable = false;
            }
        }
        return JNAAvailable;
    }

    public static void setThreadId() {
        try {
            int threadId = AffinitySupport.getThreadId();
            Field tid = Thread.class.getDeclaredField("tid");
            tid.setAccessible(true);
            Thread thread = Thread.currentThread();
            tid.setLong(thread, threadId);
            LOGGER.info("Set {} to thread id {}", (Object)thread.getName(), (Object)threadId);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static AffinityLock acquireLock() {
        return AffinitySupport.isNonForkingAffinityAvailable() ? NonForkingAffinityLock.acquireLock() : AffinityLock.acquireLock();
    }

    public static AffinityLock acquireCore() {
        return AffinitySupport.isNonForkingAffinityAvailable() ? NonForkingAffinityLock.acquireCore() : AffinityLock.acquireCore();
    }

    public static AffinityLock acquireLock(boolean bind) {
        return AffinitySupport.isNonForkingAffinityAvailable() ? NonForkingAffinityLock.acquireLock(bind) : AffinityLock.acquireLock(bind);
    }

    public static AffinityLock acquireCore(boolean bind) {
        return AffinitySupport.isNonForkingAffinityAvailable() ? NonForkingAffinityLock.acquireCore(bind) : AffinityLock.acquireCore(bind);
    }

    private static boolean isNonForkingAffinityAvailable() {
        BootClassPath bootClassPath = BootClassPath.INSTANCE;
        return bootClassPath.has("java.lang.ThreadTrackingGroup") && bootClassPath.has("java.lang.ThreadLifecycleListener");
    }

    static {
        LOGGER = LoggerFactory.getLogger(AffinitySupport.class);
        String osName = System.getProperty("os.name");
        if (osName.contains("Win") && AffinitySupport.isWindowsJNAAffinityUsable()) {
            LOGGER.trace("Using Windows JNA-based affinity control implementation");
            AFFINITY_IMPL = WindowsJNAAffinity.INSTANCE;
        } else if (osName.contains("x")) {
            if (osName.startsWith("Linux") && AffinitySupport.isLinuxJNAAffinityUsable()) {
                LOGGER.trace("Using Linux JNA-based affinity control implementation");
                AFFINITY_IMPL = LinuxJNAAffinity.INSTANCE;
            } else if (AffinitySupport.isPosixJNAAffinityUsable()) {
                LOGGER.trace("Using Posix JNA-based affinity control implementation");
                AFFINITY_IMPL = PosixJNAAffinity.INSTANCE;
            } else {
                LOGGER.info("Using dummy affinity control implementation");
                AFFINITY_IMPL = NullAffinity.INSTANCE;
            }
        } else if (osName.contains("Mac") && AffinitySupport.isMacJNAAffinityUsable()) {
            LOGGER.trace("Using MAC OSX JNA-based thread id implementation");
            AFFINITY_IMPL = OSXJNAAffinity.INSTANCE;
        } else if (osName.contains("SunOS") && AffinitySupport.isSolarisJNAAffinityUsable()) {
            LOGGER.trace("Using Solaris JNA-based thread id implementation");
            AFFINITY_IMPL = SolarisJNAAffinity.INSTANCE;
        } else {
            LOGGER.info("Using dummy affinity control implementation");
            AFFINITY_IMPL = NullAffinity.INSTANCE;
        }
    }
}

