/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.PointerType;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.LongByReference;
import net.openhft.affinity.IAffinity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WindowsJNAAffinity implements IAffinity
{
    INSTANCE;

    public static final boolean LOADED;
    private static final Logger LOGGER;

    @Override
    public long getAffinity() {
        CLibrary lib = CLibrary.INSTANCE;
        LongByReference cpuset1 = new LongByReference(0L);
        LongByReference cpuset2 = new LongByReference(0L);
        try {
            int ret = lib.GetProcessAffinityMask(-1, (PointerType)cpuset1, (PointerType)cpuset2);
            if (ret < 0) {
                throw new IllegalStateException("GetProcessAffinityMask(( -1 ), &(" + cpuset1 + "), &(" + cpuset2 + ") ) return " + ret);
            }
            return cpuset1.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public void setAffinity(long affinity) {
        CLibrary lib = CLibrary.INSTANCE;
        WinDef.DWORD aff = new WinDef.DWORD(affinity);
        int pid = this.getTid();
        try {
            lib.SetThreadAffinityMask(pid, aff);
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("SetThreadAffinityMask((" + pid + ") , &(" + affinity + ") ) errorNo=" + e.getErrorCode(), e);
        }
    }

    public int getTid() {
        CLibrary lib = CLibrary.INSTANCE;
        try {
            return lib.GetCurrentThread();
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("GetCurrentThread( ) errorNo=" + e.getErrorCode(), e);
        }
    }

    @Override
    public int getCpu() {
        return -1;
    }

    @Override
    public int getProcessId() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public int getThreadId() {
        return Kernel32.INSTANCE.GetCurrentThreadId();
    }

    static {
        LOGGER = LoggerFactory.getLogger(WindowsJNAAffinity.class);
        boolean loaded = false;
        try {
            INSTANCE.getAffinity();
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.warn("Unable to load jna library", (Throwable)e);
        }
        LOADED = loaded;
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"kernel32", CLibrary.class);

        public int GetProcessAffinityMask(int var1, PointerType var2, PointerType var3) throws LastErrorException;

        public void SetThreadAffinityMask(int var1, WinDef.DWORD var2) throws LastErrorException;

        public int GetCurrentThread() throws LastErrorException;
    }
}

