/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.util.concurrent.ThreadFactory;
import net.openhft.affinity.AffinityLock;
import net.openhft.affinity.AffinityStrategies;
import net.openhft.affinity.AffinityStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AffinityThreadFactory
implements ThreadFactory {
    private final String name;
    private final boolean daemon;
    @NotNull
    private final AffinityStrategy[] strategies;
    @Nullable
    private AffinityLock lastAffinityLock;
    private int id;

    public AffinityThreadFactory(String name, AffinityStrategy ... strategies) {
        this(name, true, strategies);
    }

    public AffinityThreadFactory(String name, boolean daemon, AffinityStrategy ... strategies) {
        AffinityStrategy[] affinityStrategyArray;
        if (strategies == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of net/openhft/affinity/AffinityThreadFactory.<init> must not be null");
        }
        this.lastAffinityLock = null;
        this.id = 1;
        this.name = name;
        this.daemon = daemon;
        if (strategies.length == 0) {
            AffinityStrategy[] affinityStrategyArray2 = new AffinityStrategy[1];
            affinityStrategyArray = affinityStrategyArray2;
            affinityStrategyArray2[0] = AffinityStrategies.ANY;
        } else {
            affinityStrategyArray = strategies;
        }
        this.strategies = affinityStrategyArray;
    }

    @Override
    @NotNull
    public synchronized Thread newThread(final @NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of net/openhft/affinity/AffinityThreadFactory.newThread must not be null");
        }
        String name2 = this.id <= 1 ? this.name : this.name + '-' + this.id;
        ++this.id;
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AffinityLock al = AffinityThreadFactory.this.lastAffinityLock == null ? AffinityLock.acquireLock() : AffinityThreadFactory.this.lastAffinityLock.acquireLock(AffinityThreadFactory.this.strategies);
                try {
                    if (al.cpuId() >= 0) {
                        AffinityThreadFactory.this.lastAffinityLock = al;
                    }
                    r.run();
                }
                finally {
                    al.release();
                }
            }
        }, name2);
        t.setDaemon(this.daemon);
        Thread thread = t;
        if (thread == null) {
            throw new IllegalStateException("@NotNull method net/openhft/affinity/AffinityThreadFactory.newThread must not return null");
        }
        return thread;
    }
}

