/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity.impl;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.affinity.IAffinity;

public enum OSXJNAAffinity implements IAffinity
{
    INSTANCE;

    private static final Logger LOGGER;

    @Override
    public long getAffinity() {
        return -1L;
    }

    @Override
    public void setAffinity(long affinity) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("unable to set mask to " + Long.toHexString(affinity) + " as the JNIa nd JNA libraries and not loaded");
        }
    }

    @Override
    public int getCpu() {
        return -1;
    }

    @Override
    public int getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(name.split("@")[0]);
    }

    @Override
    public int getThreadId() {
        int tid = CLibrary.INSTANCE.pthread_self();
        int tid_24 = tid & 0xFFFF;
        return tid_24;
    }

    static {
        LOGGER = Logger.getLogger(OSXJNAAffinity.class.getName());
    }

    static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"libpthread.dylib", CLibrary.class);

        public int pthread_self() throws LastErrorException;
    }
}

