/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import net.objectlab.kit.datecalc.common.AbstractKitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.CurrencyDateCalculatorBuilder;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.IMMDateCalculator;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;
import net.objectlab.kit.datecalc.common.SpotLag;
import net.objectlab.kit.datecalc.joda.LocalDateBackwardHandler;
import net.objectlab.kit.datecalc.joda.LocalDateCalculator;
import net.objectlab.kit.datecalc.joda.LocalDateCurrencyDateCalculator;
import net.objectlab.kit.datecalc.joda.LocalDateForwardHandler;
import net.objectlab.kit.datecalc.joda.LocalDateForwardUnlessNegativeHandler;
import net.objectlab.kit.datecalc.joda.LocalDateIMMDateCalculator;
import net.objectlab.kit.datecalc.joda.LocalDateModifiedFollowingHandler;
import net.objectlab.kit.datecalc.joda.LocalDateModifiedPrecedingHandler;
import net.objectlab.kit.datecalc.joda.LocalDatePeriodCountCalculator;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDateKitCalculatorsFactory
extends AbstractKitCalculatorsFactory<LocalDate> {
    private static final LocalDateKitCalculatorsFactory DEFAULT = new LocalDateKitCalculatorsFactory();
    private static final PeriodCountCalculator<LocalDate> PCC = new LocalDatePeriodCountCalculator();
    private static final IMMDateCalculator<LocalDate> IMMDC = new LocalDateIMMDateCalculator();

    public static LocalDateKitCalculatorsFactory getDefaultInstance() {
        return DEFAULT;
    }

    public CurrencyDateCalculatorBuilder<LocalDate> getDefaultCurrencyDateCalculatorBuilder(String ccy1, String ccy2, SpotLag spotLag) {
        CurrencyDateCalculatorBuilder builder = new CurrencyDateCalculatorBuilder().currencyPair(ccy1, ccy2, spotLag);
        return this.configureCurrencyCalculatorBuilder(builder).tenorHolidayHandler((HolidayHandler)new LocalDateModifiedFollowingHandler());
    }

    public static CurrencyDateCalculatorBuilder<LocalDate> defaultCurrencyDateCalculatorBuilder(String ccy1, String ccy2, SpotLag spotLag) {
        return DEFAULT.getDefaultCurrencyDateCalculatorBuilder(ccy1, ccy2, spotLag);
    }

    public static LocalDateCurrencyDateCalculator forwardCurrencyDateCalculator(String ccy1, String ccy2, SpotLag spotLag) {
        return DEFAULT.getDefaultCurrencyDateCalculator(ccy1, ccy2, spotLag);
    }

    public LocalDateCurrencyDateCalculator getDefaultCurrencyDateCalculator(String ccy1, String ccy2, SpotLag spotLag) {
        return new LocalDateCurrencyDateCalculator(this.getDefaultCurrencyDateCalculatorBuilder(ccy1, ccy2, spotLag));
    }

    public LocalDateCurrencyDateCalculator buildCurrencyDateCalculator(CurrencyDateCalculatorBuilder<LocalDate> builder) {
        return new LocalDateCurrencyDateCalculator(builder);
    }

    public static LocalDateCalculator forwardCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "forward");
    }

    public static LocalDateCalculator backwardCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "backward");
    }

    public static LocalDateCalculator forwardUnlessMovingBackCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "forwardUnlessMovingBack");
    }

    public static LocalDateCalculator modifiedFollowingCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "modifiedFollowing");
    }

    public static LocalDateCalculator modifiedPrecedingCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "modifiedPreceding");
    }

    public LocalDateCalculator getDateCalculator(String name, String holidayHandlerType) {
        LocalDateCalculator cal = new LocalDateCalculator();
        cal.setName(name);
        this.setHolidays(name, (DateCalculator)cal);
        cal.setHolidayHandler(this.getHolidayHandler(holidayHandlerType));
        return cal;
    }

    public HolidayHandler<LocalDate> getHolidayHandler(String holidayHandlerType) {
        if ("forward".equals(holidayHandlerType)) {
            return new LocalDateForwardHandler();
        }
        if ("backward".equals(holidayHandlerType)) {
            return new LocalDateBackwardHandler();
        }
        if ("modifiedFollowing".equals(holidayHandlerType)) {
            return new LocalDateModifiedFollowingHandler();
        }
        if ("modifiedPreceding".equals(holidayHandlerType)) {
            return new LocalDateModifiedPrecedingHandler();
        }
        if ("forwardUnlessMovingBack".equals(holidayHandlerType)) {
            return new LocalDateForwardUnlessNegativeHandler();
        }
        if (holidayHandlerType != null) {
            throw new IllegalArgumentException("Unsupported HolidayHandler: " + holidayHandlerType);
        }
        return null;
    }

    public PeriodCountCalculator<LocalDate> getPeriodCountCalculator() {
        return PCC;
    }

    public IMMDateCalculator<LocalDate> getIMMDateCalculator() {
        return IMMDC;
    }
}

