/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.joda;

import net.objectlab.kit.datecalc.common.WorkingWeek;
import org.joda.time.LocalDate;

public class JodaWorkingWeek
extends WorkingWeek {
    private static final int MAX_WEEKDAY_INDEX = 7;
    public static final JodaWorkingWeek DEFAULT = new JodaWorkingWeek();
    public static final JodaWorkingWeek ARAB_DEFAULT = new JodaWorkingWeek(WorkingWeek.ARABIC_WEEK);

    public JodaWorkingWeek() {
    }

    protected JodaWorkingWeek(byte workingDays) {
        super(workingDays);
    }

    public JodaWorkingWeek(WorkingWeek ww) {
        this(ww.getWorkingDays());
    }

    public boolean isWorkingDay(LocalDate date) {
        int dayOfWeek = JodaWorkingWeek.jodaToCalendarDayConstant(date.getDayOfWeek());
        return this.isWorkingDayFromCalendar(dayOfWeek);
    }

    public JodaWorkingWeek withWorkingDayFromDateTimeConstant(boolean working, int givenDayOfWeek) {
        int dayOfWeek = JodaWorkingWeek.jodaToCalendarDayConstant(givenDayOfWeek);
        return new JodaWorkingWeek(super.withWorkingDayFromCalendar(working, dayOfWeek));
    }

    public boolean isWorkingDayFromDateTimeConstant(int dayOfWeek) {
        return this.isWorkingDayFromCalendar(JodaWorkingWeek.jodaToCalendarDayConstant(dayOfWeek));
    }

    public static int jodaToCalendarDayConstant(LocalDate date) {
        return JodaWorkingWeek.jodaToCalendarDayConstant(date.getDayOfWeek());
    }

    public static int jodaToCalendarDayConstant(int givenDayOfWeek) {
        int dayOfWeek = givenDayOfWeek + 1;
        return dayOfWeek <= 7 ? dayOfWeek : dayOfWeek % 7;
    }
}

