/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk;

import java.util.Date;
import net.objectlab.kit.datecalc.common.AbstractKitCalculatorsFactory;
import net.objectlab.kit.datecalc.common.CurrencyDateCalculatorBuilder;
import net.objectlab.kit.datecalc.common.DateCalculator;
import net.objectlab.kit.datecalc.common.HolidayHandler;
import net.objectlab.kit.datecalc.common.IMMDateCalculator;
import net.objectlab.kit.datecalc.common.PeriodCountCalculator;
import net.objectlab.kit.datecalc.common.SpotLag;
import net.objectlab.kit.datecalc.jdk.DateBackwardHandler;
import net.objectlab.kit.datecalc.jdk.DateCurrencyDateCalculator;
import net.objectlab.kit.datecalc.jdk.DateDateCalculator;
import net.objectlab.kit.datecalc.jdk.DateForwardHandler;
import net.objectlab.kit.datecalc.jdk.DateForwardUnlessNegativeHandler;
import net.objectlab.kit.datecalc.jdk.DateIMMDateCalculator;
import net.objectlab.kit.datecalc.jdk.DateModifiedFollowingHandler;
import net.objectlab.kit.datecalc.jdk.DateModifiedPreceedingHandler;
import net.objectlab.kit.datecalc.jdk.DatePeriodCountCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateKitCalculatorsFactory
extends AbstractKitCalculatorsFactory<Date> {
    private static final DateKitCalculatorsFactory DEFAULT = new DateKitCalculatorsFactory();
    private static final PeriodCountCalculator<Date> PCC = new DatePeriodCountCalculator();
    private static final DateIMMDateCalculator IMMDC = new DateIMMDateCalculator();

    public static DateKitCalculatorsFactory getDefaultInstance() {
        return DEFAULT;
    }

    public CurrencyDateCalculatorBuilder<Date> getDefaultCurrencyDateCalculatorBuilder(String ccy1, String ccy2, SpotLag spotLag) {
        CurrencyDateCalculatorBuilder builder = new CurrencyDateCalculatorBuilder().currencyPair(ccy1, ccy2, spotLag);
        return this.configureCurrencyCalculatorBuilder(builder).tenorHolidayHandler((HolidayHandler)new DateModifiedFollowingHandler());
    }

    public static CurrencyDateCalculatorBuilder<Date> defaultCurrencyDateCalculatorBuilder(String ccy1, String ccy2, SpotLag spotLag) {
        return DEFAULT.getDefaultCurrencyDateCalculatorBuilder(ccy1, ccy2, spotLag);
    }

    public DateCurrencyDateCalculator buildCurrencyDateCalculator(CurrencyDateCalculatorBuilder<Date> builder) {
        return new DateCurrencyDateCalculator(builder);
    }

    public static DateCurrencyDateCalculator forwardCurrencyDateCalculator(String ccy1, String ccy2, SpotLag spotLag) {
        return DEFAULT.getDefaultCurrencyDateCalculator(ccy1, ccy2, spotLag);
    }

    public DateCurrencyDateCalculator getDefaultCurrencyDateCalculator(String ccy1, String ccy2, SpotLag spotLag) {
        return new DateCurrencyDateCalculator(DEFAULT.getDefaultCurrencyDateCalculatorBuilder(ccy1, ccy2, spotLag));
    }

    public static DateDateCalculator forwardCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "forward");
    }

    public static DateDateCalculator backwardCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "backward");
    }

    public static DateDateCalculator forwardUnlessMovingBackCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "forwardUnlessMovingBack");
    }

    public static DateDateCalculator modifiedFollowingCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "modifiedFollowing");
    }

    public static DateDateCalculator modifiedPrecedingCalculator(String name) {
        return DEFAULT.getDateCalculator(name, "modifiedPreceding");
    }

    public DateDateCalculator getDateCalculator(String name, String holidayHandlerType) {
        DateDateCalculator cal = new DateDateCalculator();
        cal.setName(name);
        this.setHolidays(name, (DateCalculator)cal);
        cal.setHolidayHandler(this.getHolidayHandler(holidayHandlerType));
        return cal;
    }

    public HolidayHandler<Date> getHolidayHandler(String holidayHandlerType) {
        if ("forward".equals(holidayHandlerType)) {
            return new DateForwardHandler();
        }
        if ("backward".equals(holidayHandlerType)) {
            return new DateBackwardHandler();
        }
        if ("modifiedFollowing".equals(holidayHandlerType)) {
            return new DateModifiedFollowingHandler();
        }
        if ("modifiedPreceding".equals(holidayHandlerType)) {
            return new DateModifiedPreceedingHandler();
        }
        if ("forwardUnlessMovingBack".equals(holidayHandlerType)) {
            return new DateForwardUnlessNegativeHandler();
        }
        if (holidayHandlerType != null) {
            throw new IllegalArgumentException("Unsupported HolidayHandler: " + holidayHandlerType);
        }
        return null;
    }

    public PeriodCountCalculator<Date> getPeriodCountCalculator() {
        return PCC;
    }

    public IMMDateCalculator<Date> getIMMDateCalculator() {
        return IMMDC;
    }
}

