/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.common;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.objectlab.kit.datecalc.common.HolidayCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHolidayCalendar<E>
implements HolidayCalendar<E> {
    private static final long serialVersionUID = -8558686840806739645L;
    private Map<String, E> holidays;
    private E earlyBoundary = null;
    private E lateBoundary = null;

    public DefaultHolidayCalendar() {
        this.holidays = Collections.emptyMap();
    }

    public DefaultHolidayCalendar(Set<E> holidays, E earlyBoundary, E lateBoundary) {
        this.setHolidays(holidays);
        this.earlyBoundary = earlyBoundary;
        this.lateBoundary = lateBoundary;
    }

    public DefaultHolidayCalendar(Set<E> holidays) {
        this.setHolidays(holidays);
    }

    @Override
    public E getEarlyBoundary() {
        return this.earlyBoundary;
    }

    @Override
    public Set<E> getHolidays() {
        return new HashSet<E>(this.holidays.values());
    }

    @Override
    public E getLateBoundary() {
        return this.lateBoundary;
    }

    @Override
    public HolidayCalendar<E> setEarlyBoundary(E earlyBoundary) {
        this.earlyBoundary = earlyBoundary;
        return this;
    }

    @Override
    public final HolidayCalendar<E> setHolidays(Set<E> holidays) {
        if (holidays == null) {
            this.holidays = Collections.emptyMap();
            return this;
        }
        TreeMap<String, E> newSet = new TreeMap<String, E>();
        for (E e : holidays) {
            newSet.put(this.toString(e), e);
        }
        this.holidays = Collections.unmodifiableMap(newSet);
        return this;
    }

    @Override
    public HolidayCalendar<E> setLateBoundary(E lateBoundary) {
        this.lateBoundary = lateBoundary;
        return this;
    }

    @Override
    public boolean isHoliday(E date) {
        return this.holidays.containsKey(this.toString(date));
    }

    private String toString(E date) {
        if (date instanceof Calendar) {
            return new SimpleDateFormat("yyyy-MM-dd").format(((Calendar)date).getTime());
        }
        if (date instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd").format(date);
        }
        return date != null ? date.toString() : "";
    }
}

