/*
 * Decompiled with CFR 0.152.
 */
package net.objecthunter.exp4j.tokenizer;

import java.util.Map;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.function.Functions;
import net.objecthunter.exp4j.operator.Operator;
import net.objecthunter.exp4j.operator.Operators;
import net.objecthunter.exp4j.tokenizer.ArgumentSeparatorToken;
import net.objecthunter.exp4j.tokenizer.CloseParanthesesToken;
import net.objecthunter.exp4j.tokenizer.FunctionToken;
import net.objecthunter.exp4j.tokenizer.NumberToken;
import net.objecthunter.exp4j.tokenizer.OpenParanthesesToken;
import net.objecthunter.exp4j.tokenizer.OperatorToken;
import net.objecthunter.exp4j.tokenizer.Token;
import net.objecthunter.exp4j.tokenizer.VariableToken;

public class Tokenizer {
    private final char[] expression;
    private final int expressionLength;
    private final Map<String, Function> userFunctions;
    private final Map<String, Operator> userOperators;
    private int pos = 0;
    private Token lastToken;

    public Tokenizer(String expression, Map<String, Function> userFunctions, Map<String, Operator> userOperators) {
        this.expression = expression.trim().toCharArray();
        this.expressionLength = this.expression.length;
        this.userFunctions = userFunctions;
        this.userOperators = userOperators;
    }

    public boolean hasNext() {
        return this.expression.length > this.pos;
    }

    public Token nextToken() {
        char ch;
        char val = ch = this.expression[this.pos];
        while (Character.isWhitespace(ch)) {
            ch = this.expression[++this.pos];
        }
        if (Character.isDigit(ch) || ch == '.') {
            return this.parseNumberToken(ch);
        }
        if (this.isArgumentSeparator(ch)) {
            return this.parseArumentSeparatorToken(ch);
        }
        if (this.isOpenParantheses(ch)) {
            if (this.lastToken != null && this.lastToken.getType() != 2 && this.lastToken.getType() != 4 && this.lastToken.getType() != 3 && this.lastToken.getType() != 7) {
                this.lastToken = new OperatorToken(Operators.getBuiltinOperator('*', 2));
                return this.lastToken;
            }
            return this.parseParantheses(true);
        }
        if (this.isCloseParantheses(ch)) {
            return this.parseParantheses(false);
        }
        if (Operator.isAllowedOperatorChar(ch)) {
            return this.parseOperatorToken(ch);
        }
        if (Character.isAlphabetic(ch) || ch == '_') {
            if (this.lastToken != null && this.lastToken.getType() != 2 && this.lastToken.getType() != 4 && this.lastToken.getType() != 7) {
                this.lastToken = new OperatorToken(Operators.getBuiltinOperator('*', 2));
                return this.lastToken;
            }
            return this.parseFunctionOrVariable();
        }
        throw new IllegalArgumentException("Unable to parse char '" + ch + "' (Code:" + ch + ") at [" + this.pos + "]");
    }

    private Token parseArumentSeparatorToken(char ch) {
        ++this.pos;
        this.lastToken = new ArgumentSeparatorToken();
        return this.lastToken;
    }

    private boolean isArgumentSeparator(char ch) {
        return ch == ',';
    }

    private Token parseParantheses(boolean open) {
        this.lastToken = open ? new OpenParanthesesToken() : new CloseParanthesesToken();
        ++this.pos;
        return this.lastToken;
    }

    private boolean isOpenParantheses(char ch) {
        return ch == '(' || ch == '{' || ch == '[';
    }

    private boolean isCloseParantheses(char ch) {
        return ch == ')' || ch == '}' || ch == ']';
    }

    private Token parseFunctionOrVariable() {
        String name = this.parseName();
        Function f = this.getFunction(name);
        if (f != null) {
            this.lastToken = new FunctionToken(f);
            return this.lastToken;
        }
        this.lastToken = new VariableToken(name);
        return this.lastToken;
    }

    private Function getFunction(String name) {
        Function f = null;
        if (this.userFunctions != null) {
            f = this.userFunctions.get(name);
        }
        if (f == null) {
            f = Functions.getBuiltinFunction(name);
        }
        return f;
    }

    private String parseName() {
        int offset = this.pos++;
        int len = 1;
        if (this.isEndOfExpression(offset)) {
            // empty if block
        }
        while (!this.isEndOfExpression(offset + len) && (Character.isAlphabetic(this.expression[offset + len]) || Character.isDigit(this.expression[offset + len]) || this.expression[offset + len] == '_')) {
            ++len;
        }
        this.pos += len;
        return new String(this.expression, offset, len);
    }

    private Token parseOperatorToken(char firstChar) {
        int offset = this.pos;
        int len = 1;
        StringBuilder symbol = new StringBuilder();
        Operator lastValid = null;
        symbol.append(firstChar);
        while (!this.isEndOfExpression(offset + len) && Operator.isAllowedOperatorChar(this.expression[offset + len])) {
            symbol.append(this.expression[offset + len++]);
        }
        while (symbol.length() > 0) {
            Operator op = this.getOperator(symbol.toString());
            if (op == null) {
                symbol.setLength(symbol.length() - 1);
                continue;
            }
            lastValid = op;
            break;
        }
        this.pos += symbol.length();
        this.lastToken = new OperatorToken(lastValid);
        return this.lastToken;
    }

    private Operator getOperator(String symbol) {
        Operator op = null;
        if (this.userOperators != null) {
            op = this.userOperators.get(symbol);
        }
        if (op == null && symbol.length() == 1) {
            int argc = this.lastToken == null || this.lastToken.getType() == 2 || this.lastToken.getType() == 4 ? 1 : 2;
            op = Operators.getBuiltinOperator(symbol.charAt(0), argc);
        }
        return op;
    }

    private Token parseNumberToken(char firstChar) {
        int offset;
        int len = 1;
        if (this.isEndOfExpression((offset = this.pos++) + len)) {
            this.lastToken = new NumberToken(Double.parseDouble(String.valueOf(firstChar)));
            return this.lastToken;
        }
        while (!this.isEndOfExpression(offset + len) && this.isNumeric(this.expression[offset + len], this.expression[offset + len - 1] == 'e' || this.expression[offset + len - 1] == 'E')) {
            ++len;
            ++this.pos;
        }
        this.lastToken = new NumberToken(this.expression, offset, len);
        return this.lastToken;
    }

    private boolean isNumeric(char ch, boolean lastCharE) {
        return Character.isDigit(ch) || ch == '.' || ch == 'e' || ch == 'E' || lastCharE && (ch == '-' || ch == '+');
    }

    private boolean isEndOfExpression(int offset) {
        return this.expressionLength <= offset;
    }
}

