/*
 * Decompiled with CFR 0.152.
 */
package com.bzutils;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import com.bzutils.LogBZ;
import com.bzutils.facebook.DialogError;
import com.bzutils.facebook.Facebook;
import com.bzutils.facebook.FacebookError;
import com.bzutils.listener.ContactsListener;
import com.bzutils.model.Contact;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class FacebookMethods {
    private static ContactsListener facebookContactsListener;

    FacebookMethods() {
    }

    public static void getFacebookContacts(Activity ctx, String facebookId, ContactsListener listener) {
        facebookContactsListener = listener;
        final Facebook facebook = new Facebook(facebookId);
        facebook.authorize(ctx, new String[]{"email", "read_stream", "read_friendlists", "manage_friendlists", "publish_stream", "offline_access"}, -1, new Facebook.DialogListener(){

            @Override
            public void onComplete(Bundle values) {
                new getContactsFromFacebook().execute(new String[]{facebook.getAccessToken()});
            }

            @Override
            public void onFacebookError(FacebookError error) {
                if (facebookContactsListener != null) {
                    facebookContactsListener.onContactsFailed(error.getMessage());
                }
            }

            @Override
            public void onError(DialogError e) {
                if (facebookContactsListener != null) {
                    facebookContactsListener.onContactsFailed(e.getMessage());
                }
            }

            @Override
            public void onCancel() {
                if (facebookContactsListener != null) {
                    facebookContactsListener.onContactsFailed("Action cancelled");
                }
            }
        });
    }

    private static void parseFriends(JSONObject jArray) throws JSONException {
        ArrayList<Contact> contactsFB = new ArrayList<Contact>();
        JSONArray arr = new JSONArray(jArray.getString("data"));
        for (int i = 0; i < arr.length(); ++i) {
            try {
                Contact contacto = new Contact();
                contacto.setName(arr.getJSONObject(i).optString("name"));
                contacto.setId(arr.getJSONObject(i).optString("id"));
                contacto.setUrlFoto("https://graph.facebook.com/" + contacto.getId() + "/picture");
                contactsFB.add(contacto);
                continue;
            }
            catch (JSONException e) {
                facebookContactsListener.onContactsFailed(e.getMessage());
            }
        }
        if (facebookContactsListener != null) {
            facebookContactsListener.onContactsReceived(contactsFB);
        }
    }

    private static class getContactsFromFacebook
    extends AsyncTask<String, Void, JSONObject> {
        String token = "";

        private getContactsFromFacebook() {
        }

        protected void onPreExecute() {
        }

        protected JSONObject doInBackground(String ... arg0) {
            this.token = arg0[0];
            InputStream is = null;
            String result = "";
            JSONObject jArray = null;
            try {
                DefaultHttpClient httpclient = new DefaultHttpClient();
                HttpGet httppost = new HttpGet("https://graph.facebook.com/me/friends?access_token=" + this.token);
                HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
                HttpEntity entity = response.getEntity();
                is = entity.getContent();
            }
            catch (Exception e) {
                LogBZ.getInstance();
                LogBZ.printStackTrace(e);
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is), 8);
                StringBuilder sb = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line + "\n");
                }
                is.close();
                result = sb.toString();
                LogBZ.getInstance();
                LogBZ.e("RESULT" + result);
            }
            catch (Exception e) {
                LogBZ.getInstance();
                LogBZ.printStackTrace(e);
            }
            try {
                jArray = new JSONObject(result);
            }
            catch (JSONException e) {
                LogBZ.getInstance();
                LogBZ.printStackTrace((Exception)((Object)e));
            }
            return jArray;
        }

        protected void onPostExecute(JSONObject st) {
            block2: {
                try {
                    FacebookMethods.parseFriends(st);
                }
                catch (JSONException e) {
                    if (facebookContactsListener == null) break block2;
                    facebookContactsListener.onContactsFailed(e.getMessage());
                }
            }
        }
    }
}

