/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.lib.core.networking.encoding;

import com.testflightapp.lib.core.Logger;
import com.testflightapp.lib.core.networking.encoding.DecoderFormatException;
import com.testflightapp.lib.core.networking.encoding.IParameterDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.msgpack.MessagePack;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.MapValue;
import org.msgpack.type.Value;
import org.msgpack.unpacker.BufferUnpacker;

public class MPParameterDecoder
implements IParameterDecoder {
    @Override
    public Map<String, Object> decode(HttpEntity httpEntity) throws DecoderFormatException {
        if (httpEntity == null) {
            Logger.e("null passed to MPParameterDecoder.decode");
            throw new NullPointerException("Cannot encode null parameters");
        }
        try {
            MessagePack messagePack = new MessagePack();
            BufferUnpacker bufferUnpacker = messagePack.createBufferUnpacker(EntityUtils.toByteArray((HttpEntity)httpEntity));
            ArrayList<Value> arrayList = new ArrayList<Value>();
            for (Value value : bufferUnpacker) {
                arrayList.add(value);
            }
            if (arrayList.size() != 1 || !((Value)arrayList.get(0)).isMapValue()) {
                throw new DecoderFormatException("Invalid message pack data format. Requests and responses should hold a single map type");
            }
            return (Map)MPParameterDecoder.extractMembers((Value)arrayList.get(0));
        }
        catch (IOException iOException) {
            Logger.wtf("Unexpected error decoding data.", iOException);
            throw new DecoderFormatException("Unexpected error decoding data.", iOException);
        }
    }

    private static Object extractMembers(Value value) throws DecoderFormatException {
        if (value.isMapValue()) {
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            MapValue mapValue = value.asMapValue();
            for (Map.Entry entry : mapValue.entrySet()) {
                String string = ((Value)entry.getKey()).toString();
                string = string.substring(1, string.length() - 1);
                treeMap.put(string, MPParameterDecoder.extractMembers((Value)entry.getValue()));
            }
            return treeMap;
        }
        if (value.isArrayValue()) {
            ArrayValue arrayValue = value.asArrayValue();
            Object[] objectArray = new Object[arrayValue.size()];
            for (int i = 0; i < arrayValue.size(); ++i) {
                objectArray[i] = MPParameterDecoder.extractMembers((Value)arrayValue.get(i));
            }
            return objectArray;
        }
        if (value.isBooleanValue()) {
            return value.asBooleanValue().getBoolean();
        }
        if (value.isIntegerValue()) {
            return value.asIntegerValue().getInt();
        }
        if (value.isFloatValue()) {
            return Float.valueOf(value.asFloatValue().getFloat());
        }
        if (value.isNilValue()) {
            return null;
        }
        if (value.isRawValue()) {
            String string = value.toString();
            return string.substring(1, string.length() - 1);
        }
        Logger.e("Invalid Message Pack: Value type " + value.getType().toString() + " unsupported");
        throw new DecoderFormatException("Invalid Message Pack: Value type " + value.getType().toString() + " unsupported");
    }
}

