/*
 * Decompiled with CFR 0.152.
 */
package com.testflightapp.acra.util;

import android.content.Context;
import android.util.Log;
import com.testflightapp.acra.ACRA;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;

public class Installation {
    private static String sID;
    private static final String INSTALLATION = "ACRA-INSTALLATION";

    public static synchronized String id(Context context) {
        if (sID == null) {
            File installation = new File(context.getFilesDir(), INSTALLATION);
            try {
                if (!installation.exists()) {
                    Installation.writeInstallationFile(installation);
                }
                sID = Installation.readInstallationFile(installation);
            }
            catch (IOException e) {
                Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve InstallationId for " + context.getPackageName()), (Throwable)e);
                return "Couldn't retrieve InstallationId";
            }
            catch (RuntimeException e) {
                Log.w((String)ACRA.LOG_TAG, (String)("Couldn't retrieve InstallationId for " + context.getPackageName()), (Throwable)e);
                return "Couldn't retrieve InstallationId";
            }
        }
        return sID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInstallationFile(File installation) throws IOException {
        RandomAccessFile f = new RandomAccessFile(installation, "r");
        byte[] bytes = new byte[(int)f.length()];
        try {
            f.readFully(bytes);
        }
        finally {
            f.close();
        }
        return new String(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInstallationFile(File installation) throws IOException {
        FileOutputStream out = new FileOutputStream(installation);
        try {
            String id = UUID.randomUUID().toString();
            out.write(id.getBytes());
        }
        finally {
            out.close();
        }
    }
}

