/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.TintTypedArray;
import java.util.List;
import net.mm2d.preference.Header;
import net.mm2d.preference.R;

class HeaderAdapter
extends ArrayAdapter<Header> {
    private final int mColorAccent;
    @NonNull
    private final LayoutInflater mInflater;

    HeaderAdapter(@NonNull Context context, @NonNull List<Header> objects) {
        super(context, 0, objects);
        this.mInflater = LayoutInflater.from((Context)context);
        this.mColorAccent = Build.VERSION.SDK_INT < 21 ? HeaderAdapter.getThemeAttrColor(context, R.attr.colorAccent) : 0;
    }

    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        ViewHolder holder;
        View view;
        if (convertView == null) {
            view = this.mInflater.inflate(R.layout.mm2d_pac_header_item, parent, false);
            this.setBackground(view);
            holder = new ViewHolder((ImageView)view.findViewById(R.id.icon), (TextView)view.findViewById(R.id.title), (TextView)view.findViewById(R.id.summary));
            view.setTag((Object)holder);
        } else {
            view = convertView;
            holder = (ViewHolder)view.getTag();
        }
        ImageView icon = holder.getIcon();
        Header header = (Header)this.getItem(position);
        if (header.iconRes == 0) {
            icon.setVisibility(8);
        } else {
            icon.setVisibility(0);
            icon.setImageResource(header.iconRes);
        }
        Resources resources = this.getContext().getResources();
        holder.getTitle().setText(header.getTitle(resources));
        TextView summary = holder.getSummary();
        CharSequence text = header.getSummary(resources);
        if (!TextUtils.isEmpty((CharSequence)text)) {
            summary.setVisibility(0);
            summary.setText(text);
        } else {
            summary.setVisibility(8);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RestrictedApi"})
    private static int getThemeAttrColor(@NonNull Context context, int attr2) {
        TintTypedArray a = TintTypedArray.obtainStyledAttributes((Context)context, null, (int[])new int[]{attr2});
        try {
            int n = a.getColor(0, 0);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    private void setBackground(@NonNull View view) {
        if (this.mColorAccent == 0) {
            return;
        }
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{16843518}, (Drawable)new ColorDrawable(this.mColorAccent));
        drawable.addState(new int[]{-16843518}, (Drawable)new ColorDrawable(0));
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)drawable);
        } else {
            view.setBackgroundDrawable((Drawable)drawable);
        }
    }

    private static class ViewHolder {
        private final ImageView mIcon;
        private final TextView mTitle;
        private final TextView mSummary;

        ViewHolder(@NonNull ImageView icon, @NonNull TextView title, @NonNull TextView summary) {
            this.mIcon = icon;
            this.mTitle = title;
            this.mSummary = summary;
        }

        ImageView getIcon() {
            return this.mIcon;
        }

        TextView getTitle() {
            return this.mTitle;
        }

        TextView getSummary() {
            return this.mSummary;
        }
    }
}

