/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.preference;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.XmlRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v7.preference.Preference;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.mm2d.preference.Header;
import net.mm2d.preference.HeaderAdapter;
import net.mm2d.preference.HeaderLoader;
import net.mm2d.preference.R;

public class PreferenceActivityCompatDelegate {
    public static final long HEADER_ID_UNDEFINED = -1L;
    private static final String HEADERS_TAG = ":android:headers";
    private static final String CUR_HEADER_TAG = ":android:cur_header";
    private static final String BACK_STACK_PREFS = ":android:prefs";
    @NonNull
    private final FragmentActivity mActivity;
    @NonNull
    private final Connector mConnector;
    @NonNull
    private final AdapterView.OnItemClickListener mOnClickListener = (parent, view, position, id2) -> this.onListItemClick(position);
    @NonNull
    private final ArrayList<Header> mHeaders = new ArrayList();
    private ListAdapter mAdapter;
    private ListView mList;
    private boolean mFinishedStart = false;
    private FrameLayout mListFooter;
    private ViewGroup mPrefsContainer;
    private ViewGroup mHeadersContainer;
    private TextView mBreadCrumbTitle;
    private boolean mSinglePane;
    private Header mCurHeader;
    private final Handler mHandler = new Handler();
    private Fragment mFragment;
    private final Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            PreferenceActivityCompatDelegate.this.mList.focusableViewAvailable((View)PreferenceActivityCompatDelegate.this.mList);
        }
    };
    private final Runnable mBuildHeaders = new Runnable(){

        @Override
        public void run() {
            Header mappedHeader;
            PreferenceActivityCompatDelegate.this.mHeaders.clear();
            PreferenceActivityCompatDelegate.this.mConnector.onBuildHeaders(PreferenceActivityCompatDelegate.this.mHeaders);
            if (PreferenceActivityCompatDelegate.this.mAdapter instanceof BaseAdapter) {
                ((BaseAdapter)PreferenceActivityCompatDelegate.this.mAdapter).notifyDataSetChanged();
            }
            if (PreferenceActivityCompatDelegate.this.mCurHeader != null && (mappedHeader = PreferenceActivityCompatDelegate.this.findBestMatchingHeader(PreferenceActivityCompatDelegate.this.mCurHeader, PreferenceActivityCompatDelegate.this.mHeaders)) != null) {
                PreferenceActivityCompatDelegate.this.setSelectedHeader(mappedHeader);
            }
        }
    };

    public PreferenceActivityCompatDelegate(@NonNull FragmentActivity activity, @NonNull Connector connector) {
        this.mActivity = activity;
        this.mConnector = connector;
    }

    @NonNull
    private Context getContext() {
        return this.mActivity;
    }

    @NonNull
    private Resources getResources() {
        return this.mActivity.getResources();
    }

    private boolean isResumed() {
        return this.mActivity.getLifecycle().getCurrentState() == Lifecycle.State.RESUMED;
    }

    @NonNull
    private FragmentManager getFragmentManager() {
        return this.mActivity.getSupportFragmentManager();
    }

    @Nullable
    private CharSequence getTitle() {
        return this.mActivity.getTitle();
    }

    private void setTitle(@Nullable CharSequence title) {
        this.mActivity.setTitle(title);
    }

    private void setContentView(@LayoutRes int layoutResID) {
        this.mActivity.setContentView(layoutResID);
    }

    @Nullable
    private <T extends View> T findViewById(@IdRes int id2) {
        return (T)this.mActivity.findViewById(id2);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        this.setContentView(R.layout.content);
        this.mList = (ListView)this.findViewById(R.id.list);
        this.mList.setOnItemClickListener(this.mOnClickListener);
        if (this.mFinishedStart) {
            this.setListAdapter(this.mAdapter);
        }
        this.mHandler.post(this.mRequestFocus);
        this.mFinishedStart = true;
        this.mListFooter = (FrameLayout)this.findViewById(R.id.list_footer);
        this.mPrefsContainer = (ViewGroup)this.findViewById(R.id.prefs_frame);
        this.mHeadersContainer = (ViewGroup)this.findViewById(R.id.headers);
        this.mSinglePane = !this.mConnector.onIsMultiPane();
        Object breadCrumbSection = this.findViewById(R.id.breadcrumb_section);
        this.mBreadCrumbTitle = (TextView)this.findViewById(R.id.bread_crumb_title);
        if (this.mSinglePane && breadCrumbSection != null && this.mBreadCrumbTitle != null) {
            this.mBreadCrumbTitle.setVisibility(8);
            breadCrumbSection.setVisibility(8);
        }
        if (savedInstanceState != null) {
            ArrayList headers = savedInstanceState.getParcelableArrayList(HEADERS_TAG);
            if (headers != null) {
                this.mHeaders.addAll(headers);
                int curHeader = savedInstanceState.getInt(CUR_HEADER_TAG, -1);
                if (curHeader >= 0 && curHeader < this.mHeaders.size()) {
                    this.setSelectedHeader(this.mHeaders.get(curHeader));
                } else if (!this.mSinglePane) {
                    this.switchToHeader(this.onGetInitialHeader());
                }
            } else {
                this.showBreadCrumbs(this.getTitle());
            }
        } else {
            this.mConnector.onBuildHeaders(this.mHeaders);
            if (!this.mSinglePane && this.mHeaders.size() > 0) {
                this.switchToHeader(this.onGetInitialHeader());
            }
        }
        if (this.mHeaders.size() > 0) {
            this.setListAdapter((ListAdapter)new HeaderAdapter(this.getContext(), this.mHeaders));
            if (!this.mSinglePane) {
                this.mList.setChoiceMode(1);
            }
        }
        if (this.mSinglePane) {
            if (this.mCurHeader != null) {
                this.mHeadersContainer.setVisibility(8);
            } else {
                this.mPrefsContainer.setVisibility(8);
            }
        } else if (this.mHeaders.size() > 0 && this.mCurHeader != null) {
            this.setSelectedHeader(this.mCurHeader);
        }
    }

    public void onDestroy() {
        this.mHandler.removeCallbacks(this.mBuildHeaders);
        this.mHandler.removeCallbacks(this.mRequestFocus);
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.mHeaders.size() > 0) {
            int index;
            outState.putParcelableArrayList(HEADERS_TAG, this.mHeaders);
            if (this.mCurHeader != null && (index = this.mHeaders.indexOf(this.mCurHeader)) >= 0) {
                outState.putInt(CUR_HEADER_TAG, index);
            }
        }
    }

    public void onRestoreInstanceState(@NonNull Bundle state) {
        if (!this.mSinglePane && this.mCurHeader != null) {
            this.setSelectedHeader(this.mCurHeader);
        }
    }

    public boolean onBackPressed() {
        FragmentManager manager = this.getFragmentManager();
        if (this.mCurHeader == null || !this.mSinglePane || manager.getBackStackEntryCount() != 0) {
            return false;
        }
        if (this.mFragment != null) {
            manager.beginTransaction().remove(this.mFragment).commitAllowingStateLoss();
            this.mFragment = null;
        }
        this.mCurHeader = null;
        this.mPrefsContainer.setVisibility(8);
        this.mHeadersContainer.setVisibility(0);
        this.showBreadCrumbs(this.getTitle());
        this.mList.clearChoices();
        return true;
    }

    private void setListAdapter(ListAdapter adapter) {
        this.mAdapter = adapter;
        this.mList.setAdapter(adapter);
    }

    public int getSelectedItemPosition() {
        return this.mList.getSelectedItemPosition();
    }

    public boolean hasHeaders() {
        return this.mHeadersContainer != null && this.mHeadersContainer.getVisibility() == 0;
    }

    @NonNull
    public List<Header> getHeaders() {
        return this.mHeaders;
    }

    public boolean isMultiPane() {
        return !this.mSinglePane;
    }

    @NonNull
    private Header onGetInitialHeader() {
        for (int i = 0; i < this.mHeaders.size(); ++i) {
            Header h = this.mHeaders.get(i);
            if (h.fragment == null) continue;
            return h;
        }
        throw new IllegalStateException("Must have at least one header with a fragment");
    }

    public void invalidateHeaders() {
        this.mHandler.removeCallbacks(this.mBuildHeaders);
        this.mHandler.post(this.mBuildHeaders);
    }

    public void loadHeadersFromResource(@XmlRes int resId, @NonNull List<Header> target) {
        HeaderLoader.loadFromResource(this.getContext(), resId, target);
    }

    public void setListFooter(@NonNull View view) {
        this.mListFooter.removeAllViews();
        this.mListFooter.addView(view, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
    }

    private void onListItemClick(int position) {
        Object item;
        if (!this.isResumed()) {
            return;
        }
        if (this.mAdapter != null && (item = this.mAdapter.getItem(position)) instanceof Header) {
            this.onHeaderClick((Header)item);
        }
    }

    private void onHeaderClick(@NonNull Header header) {
        if (header.fragment != null) {
            this.switchToHeader(header);
        } else if (header.intent != null) {
            this.getContext().startActivity(header.intent);
        }
    }

    public void switchToHeader(@NonNull Header header) {
        if (this.mCurHeader == header) {
            this.getFragmentManager().popBackStack(BACK_STACK_PREFS, 1);
        } else {
            if (header.fragment == null) {
                throw new IllegalStateException("can't switch to header that has no fragment");
            }
            this.mHandler.post(() -> {
                this.switchToHeaderInner(header.fragment, header.fragmentArguments);
                this.setSelectedHeader(header);
            });
        }
    }

    private void switchToHeaderInner(@NonNull String fragmentName, @Nullable Bundle args) {
        FragmentManager fragmentManager = this.getFragmentManager();
        fragmentManager.popBackStack(BACK_STACK_PREFS, 1);
        if (!this.mConnector.isValidFragment(fragmentName)) {
            throw new IllegalArgumentException("Invalid fragment for this activity: " + fragmentName);
        }
        this.mFragment = Fragment.instantiate((Context)this.getContext(), (String)fragmentName, (Bundle)args);
        fragmentManager.beginTransaction().setTransition(0).replace(R.id.prefs, this.mFragment).commitAllowingStateLoss();
        if (this.mSinglePane && this.mPrefsContainer.getVisibility() == 8) {
            this.mPrefsContainer.setVisibility(0);
            this.mHeadersContainer.setVisibility(8);
        }
    }

    private void setSelectedHeader(@NonNull Header header) {
        this.mCurHeader = header;
        int index = this.mHeaders.indexOf(header);
        if (index >= 0) {
            this.mList.setItemChecked(index, true);
        } else {
            this.mList.clearChoices();
        }
        this.showBreadCrumbs(header);
    }

    private void showBreadCrumbs(@NonNull Header header) {
        Resources resources = this.getResources();
        CharSequence title = header.getBreadCrumbTitle(resources);
        if (title == null) {
            title = header.getTitle(resources);
        }
        if (title == null) {
            title = this.getTitle();
        }
        this.showBreadCrumbs(title);
    }

    private void showBreadCrumbs(@Nullable CharSequence title) {
        if (this.mBreadCrumbTitle == null) {
            this.setTitle(title);
            return;
        }
        if (this.mBreadCrumbTitle.getVisibility() != 0) {
            this.setTitle(title);
        } else {
            this.mBreadCrumbTitle.setText(title);
        }
    }

    public void startPreferenceFragment(@NonNull Preference pref) {
        Fragment fragment = Fragment.instantiate((Context)this.getContext(), (String)pref.getFragment(), (Bundle)pref.getExtras());
        this.getFragmentManager().beginTransaction().replace(R.id.prefs, fragment).setBreadCrumbTitle(pref.getTitle()).setTransition(0).addToBackStack(BACK_STACK_PREFS).commitAllowingStateLoss();
    }

    @Nullable
    private Header findBestMatchingHeader(@NonNull Header cur, @NonNull ArrayList<Header> from) {
        int NM;
        ArrayList<Header> matches = new ArrayList<Header>();
        for (int j = 0; j < from.size(); ++j) {
            Header oh = from.get(j);
            if (cur == oh || cur.id != -1L && cur.id == oh.id) {
                matches.clear();
                matches.add(oh);
                break;
            }
            if (cur.fragment != null) {
                if (!cur.fragment.equals(oh.fragment)) continue;
                matches.add(oh);
                continue;
            }
            if (cur.intent != null) {
                if (!cur.intent.equals(oh.intent)) continue;
                matches.add(oh);
                continue;
            }
            if (cur.title == null || !cur.title.equals(oh.title)) continue;
            matches.add(oh);
        }
        if ((NM = matches.size()) == 1) {
            return (Header)matches.get(0);
        }
        if (NM > 1) {
            for (int j = 0; j < NM; ++j) {
                Header oh = (Header)matches.get(j);
                if (cur.fragmentArguments != null && cur.fragmentArguments.equals(oh.fragmentArguments)) {
                    return oh;
                }
                if (cur.extras != null && cur.extras.equals(oh.extras)) {
                    return oh;
                }
                if (cur.title == null || !cur.title.equals(oh.title)) continue;
                return oh;
            }
        }
        return null;
    }

    public static interface Connector {
        public void onBuildHeaders(@NonNull List<Header> var1);

        public boolean onIsMultiPane();

        public boolean isValidFragment(@Nullable String var1);
    }
}

