/*
 * Decompiled with CFR 0.152.
 */
package net.mm2d.preference;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.TintTypedArray;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.List;
import java.util.Objects;
import net.mm2d.preference.Header;
import net.mm2d.preference.R;

class HeaderAdapter
extends ArrayAdapter<Header> {
    private final int mColorAccent;
    @NonNull
    private final LayoutInflater mInflater;

    HeaderAdapter(@NonNull Context context, @NonNull List<Header> objects) {
        super(context, 0, objects);
        Object service = context.getSystemService("layout_inflater");
        this.mInflater = (LayoutInflater)Objects.requireNonNull(service);
        this.mColorAccent = Build.VERSION.SDK_INT < 21 ? HeaderAdapter.getThemeAttrColor(context, R.attr.colorAccent) : 0;
    }

    @NonNull
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        HeaderViewHolder holder;
        View view;
        if (convertView == null) {
            view = this.mInflater.inflate(R.layout.header_item, parent, false);
            this.setBackground(view);
            holder = new HeaderViewHolder();
            holder.icon = (ImageView)view.findViewById(R.id.icon);
            holder.title = (TextView)view.findViewById(R.id.title);
            holder.summary = (TextView)view.findViewById(R.id.summary);
            view.setTag((Object)holder);
        } else {
            view = convertView;
            holder = (HeaderViewHolder)view.getTag();
        }
        Header header = (Header)this.getItem(position);
        assert (header != null);
        if (header.iconRes == 0) {
            holder.icon.setVisibility(8);
        } else {
            holder.icon.setVisibility(0);
            holder.icon.setImageResource(header.iconRes);
        }
        holder.title.setText(header.getTitle(this.getContext().getResources()));
        CharSequence summary = header.getSummary(this.getContext().getResources());
        if (!TextUtils.isEmpty((CharSequence)summary)) {
            holder.summary.setVisibility(0);
            holder.summary.setText(summary);
        } else {
            holder.summary.setVisibility(8);
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RestrictedApi"})
    private static int getThemeAttrColor(@NonNull Context context, int attr2) {
        TintTypedArray a = TintTypedArray.obtainStyledAttributes((Context)context, null, (int[])new int[]{attr2});
        try {
            int n = a.getColor(0, 0);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    private void setBackground(@NonNull View view) {
        if (this.mColorAccent == 0) {
            return;
        }
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{16843518}, (Drawable)new ColorDrawable(this.mColorAccent));
        drawable.addState(new int[]{-16843518}, (Drawable)new ColorDrawable(0));
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)drawable);
        } else {
            view.setBackgroundDrawable((Drawable)drawable);
        }
    }

    private static class HeaderViewHolder {
        ImageView icon;
        TextView title;
        TextView summary;

        private HeaderViewHolder() {
        }
    }
}

