/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.biz.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.constant.e.BaseEnum;
import net.mingsoft.base.constant.e.DeleteEnum;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.constant.e.ManagerAdminEnum;
import net.mingsoft.basic.constant.e.ModelIsMenuEnum;
import net.mingsoft.basic.dao.IModelDao;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import net.mingsoft.basic.exception.BusinessException;
import net.mingsoft.basic.util.BasicUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="modelBiz")
@Transactional
public class ModelBizImpl
extends BaseBizImpl<IModelDao, ModelEntity>
implements IModelBiz {
    private IModelDao modelDao;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @Override
    public ModelEntity getEntityByModelCode(BaseEnum modelCode) {
        return this.modelDao.getEntityByModelCode(modelCode.toString());
    }

    @Override
    public ModelEntity getEntityByModelCode(String modelCode) {
        return this.modelDao.getEntityByModelCode(modelCode);
    }

    public IModelDao getModelDao() {
        return this.modelDao;
    }

    @Autowired
    public void setModelDao(IModelDao modelDao) {
        this.modelDao = modelDao;
    }

    protected IBaseDao getDao() {
        return this.modelDao;
    }

    @Override
    public ModelEntity getModel(String modelType, int modelId) {
        return this.modelDao.getModel(modelType, modelId);
    }

    @Override
    public List<ModelEntity> queryModelByRoleId(int roleId) {
        return this.modelDao.queryModelByRoleId(roleId);
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class, Error.class})
    public void reModel(ModelEntity modelParent, String parentIds, int mangerRoleId, List<RoleModelEntity> roleModels, Integer parentId) {
        modelParent.setModelIsMenu(ObjectUtil.isNotNull(modelParent.getModelChildList()) && modelParent.getModelChildList().size() > 0 ? Integer.valueOf(1) : Integer.valueOf(0));
        modelParent.setModelId(parentId);
        modelParent.setModelDatetime(new Timestamp(System.currentTimeMillis()));
        modelParent.setModelParentIds(parentIds);
        ModelEntity modelParentEntity = this.getEntityByModelCode(modelParent.getModelCode());
        if (modelParentEntity == null) {
            if (modelParent.getModelIsMenu().intValue() == ModelIsMenuEnum.MODEL_MEUN.toInt()) {
                ModelEntity modelEntity = new ModelEntity();
                modelEntity.setModelIsMenu(ModelIsMenuEnum.MODEL_MEUN.toInt());
                modelEntity.setModelTitle(modelParent.getModelTitle());
                modelEntity.setModelId(modelParent.getModelId());
                if (ObjectUtil.isNotEmpty((Object)this.getEntity(modelEntity))) {
                    throw new BusinessException("\u83dc\u5355\u6807\u9898\u91cd\u590d");
                }
            }
            this.saveEntity(modelParent);
            RoleModelEntity roleModel = new RoleModelEntity();
            roleModel.setRoleId(mangerRoleId);
            roleModel.setModelId(Integer.parseInt(modelParent.getId()));
            roleModels.add(roleModel);
        } else {
            modelParent.setId(modelParentEntity.getId());
            this.updateEntity(modelParent);
        }
        if (ObjectUtil.isNotNull(modelParent.getModelChildList()) && modelParent.getModelChildList().size() > 0) {
            for (ModelEntity modelEntity : modelParent.getModelChildList()) {
                this.reModel(modelEntity, (String)(StringUtils.isBlank((CharSequence)parentIds) ? modelParent.getId() : parentIds + "," + modelParent.getId()), mangerRoleId, roleModels, Integer.parseInt(modelParent.getId()));
            }
        }
    }

    @Override
    @Deprecated
    @Transactional(rollbackFor={Exception.class})
    public void jsonToModel(String menuStr, int mangerRoleId, int modelId) {
        ArrayList<RoleModelEntity> roleModels = new ArrayList<RoleModelEntity>();
        if (StringUtils.isNotBlank((CharSequence)menuStr)) {
            List list = JSONUtil.toList((String)menuStr, ModelEntity.class);
            for (ModelEntity modelParent : list) {
                ModelEntity entity = (ModelEntity)((Object)this.getEntity(modelParent));
                if (entity != null && (entity.getModelId() == null || entity.getModelId() == 0)) {
                    this.deleteEntity(Integer.parseInt(entity.getId()));
                }
                this.reModel(modelParent, null, mangerRoleId, roleModels, modelId);
            }
            if (roleModels.size() > 0) {
                this.roleModelBiz.saveBatch(roleModels, roleModels.size());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class, Error.class})
    public void importModel(ModelEntity modelEntity, int mangerRoleId, String parentIds, Integer modelId) {
        ArrayList<RoleModelEntity> roleModels = new ArrayList<RoleModelEntity>();
        modelEntity.setId(null);
        modelEntity.setModelDatetime(new Timestamp(System.currentTimeMillis()));
        if (modelId != null && modelId != 0) {
            modelEntity.setModelId(modelId);
            modelEntity.setModelParentIds((String)parentIds);
        } else {
            modelEntity.setModelId(null);
            modelEntity.setModelParentIds(null);
        }
        this.modelDao.insert((Object)modelEntity);
        RoleModelEntity roleModel = new RoleModelEntity();
        roleModel.setRoleId(mangerRoleId);
        roleModel.setModelId(Integer.parseInt(modelEntity.getId()));
        roleModels.add(roleModel);
        if (roleModels.size() > 0) {
            this.roleModelBiz.saveBatch(roleModels, roleModels.size());
        }
        if (ObjectUtil.isNotNull(modelEntity.getModelChildList()) && modelEntity.getModelChildList().size() > 0) {
            parentIds = StringUtils.isBlank((CharSequence)parentIds) || modelId == null || modelId == 0 ? modelEntity.getId() : (String)parentIds + "," + modelEntity.getId();
            for (ModelEntity curModelEntity : modelEntity.getModelChildList()) {
                this.importModel(curModelEntity, mangerRoleId, (String)parentIds, Integer.parseInt(modelEntity.getId()));
            }
        }
    }

    @Override
    public void updateEntity(ModelEntity model) {
        this.setParentId(model);
        this.modelDao.updateById((Object)model);
        this.setChildParentId(model);
        this.modelDao.updateCache();
    }

    @Override
    public void saveEntity(ModelEntity model) {
        this.setParentId(model);
        this.modelDao.insert((Object)model);
        this.modelDao.updateCache();
    }

    @Override
    public List<ModelEntity> queryChildList(ModelEntity modelEntity) {
        ModelEntity model = (ModelEntity)((Object)this.modelDao.selectOne((Wrapper)new QueryWrapper((Object)modelEntity)));
        if (model == null) {
            return null;
        }
        ModelEntity _model = new ModelEntity();
        _model.setModelId(model.getIntId());
        List list = this.modelDao.selectList((Wrapper)new QueryWrapper((Object)_model));
        return list;
    }

    @Override
    public List<ModelEntity> queryAllChildList(ModelEntity modelEntity) {
        ModelEntity model = (ModelEntity)((Object)this.modelDao.selectOne((Wrapper)new QueryWrapper((Object)modelEntity)));
        if (model == null) {
            return null;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getDel, (Object)DeleteEnum.NOTDEL.toInt())).last(StrUtil.format((CharSequence)"AND find_in_set({}, model_parent_ids) > 0", (Object[])new Object[]{model.getId()}));
        return this.modelDao.selectList((Wrapper)wrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, Error.class})
    public void saveModel(ModelEntity model) {
        model.setAppId(null);
        this.save((Object)model);
        ManagerEntity manager = BasicUtil.getManager();
        assert (manager != null);
        if (!ManagerAdminEnum.SUPER.toString().equals(manager.getManagerAdmin()) && StringUtils.isNotEmpty((CharSequence)model.getId())) {
            ArrayList<RoleModelEntity> roleModels = new ArrayList<RoleModelEntity>();
            for (String roleId : manager.getRoleIds().split(",")) {
                RoleModelEntity roleModel = new RoleModelEntity();
                roleModel.setModelId(Integer.parseInt(model.getId()));
                roleModel.setRoleId(Integer.parseInt(roleId));
                roleModels.add(roleModel);
            }
            this.roleModelBiz.saveBatch(roleModels, roleModels.size());
        }
        this.updateCache();
    }

    @Override
    public void delete(List<ModelEntity> modelEntities) {
        if (CollUtil.isEmpty(modelEntities)) {
            return;
        }
        ArrayList<ModelEntity> modelEntityList = new ArrayList<ModelEntity>();
        for (ModelEntity model : modelEntities) {
            ModelEntity modelEntity = new ModelEntity();
            modelEntity.setId(model.getId());
            List<ModelEntity> tempList = this.queryAllChildList(modelEntity);
            modelEntityList.add(modelEntity);
            if (!CollectionUtil.isNotEmpty(tempList)) continue;
            modelEntityList.addAll(tempList);
        }
        this.roleModelBiz.deleteByModelIds(modelEntityList);
        this.modelDao.deleteByIds(modelEntities);
        this.modelDao.updateCache();
    }

    private void setParentId(ModelEntity model) {
        if (model.getModelId() != null && model.getModelId() > 0) {
            ModelEntity _model = (ModelEntity)((Object)this.modelDao.selectById(model.getModelId()));
            if (StringUtils.isEmpty((CharSequence)_model.getModelParentIds())) {
                model.setModelParentIds(_model.getId());
            } else {
                model.setModelParentIds(_model.getModelParentIds() + "," + _model.getId());
            }
        } else {
            model.setModelParentIds(null);
            model.setModelId(null);
        }
    }

    private void setChildParentId(ModelEntity model) {
        ModelEntity _model = new ModelEntity();
        _model.setModelId(Integer.parseInt(model.getId()));
        List list = this.modelDao.query(_model);
        list.forEach(x -> {
            if (StringUtils.isEmpty((CharSequence)model.getModelParentIds())) {
                x.setModelParentIds(model.getId());
            } else {
                x.setModelParentIds(model.getModelParentIds() + "," + model.getId());
            }
            super.updateEntity((BaseEntity)x);
            this.setChildParentId((ModelEntity)((Object)x));
        });
    }
}

