/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.log.Log;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.annotation.LogAnn;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.biz.IModelBiz;
import net.mingsoft.basic.biz.IRoleModelBiz;
import net.mingsoft.basic.constant.e.BusinessTypeEnum;
import net.mingsoft.basic.constant.e.ModelIsMenuEnum;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.ModelEntity;
import net.mingsoft.basic.entity.RoleModelEntity;
import net.mingsoft.basic.strategy.IModelStrategy;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u57fa\u7840\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/model"})
public class ModelAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IModelStrategy modelStrategy;
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;

    @Hidden
    @GetMapping(value={"/index"})
    @RequiresPermissions(value={"basic:model:view"})
    public String index(HttpServletResponse response, HttpServletRequest request, ModelMap mode) {
        List<ModelEntity> parentModelList = this.modelStrategy.list();
        mode.addAttribute("parentModelList", (Object)JSONUtil.toJsonStr(parentModelList));
        return "/basic/model/index";
    }

    @Operation(summary="\u83dc\u5355\u5217\u8868\u63a5\u53e3")
    @GetMapping(value={"/list"})
    @ResponseBody
    public ResultData list(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        List<ModelEntity> modelList = this.modelStrategy.list();
        if (CollectionUtil.isEmpty(modelList)) {
            return ResultData.build().success();
        }
        modelList.sort((o1, o2) -> {
            int sort1 = o1.getModelSort() == null ? 0 : o1.getModelSort();
            int sort2 = o2.getModelSort() == null ? 0 : o2.getModelSort();
            return sort2 - sort1;
        });
        EUListBean _list = new EUListBean(modelList, modelList.size());
        return ResultData.build().success((Object)_list);
    }

    @Operation(summary="\u83dc\u5355\u5b50\u96c6\u5217\u8868")
    @GetMapping(value={"/childList"})
    @Parameters(value={@Parameter(name="modelTitle", description="\u83dc\u5355\u540d\u79f0", required=false, in=ParameterIn.QUERY), @Parameter(name="modelId", description="\u7236\u7ea7\u83dc\u5355\u7f16\u53f7", required=false, in=ParameterIn.QUERY)})
    @RequiresPermissions(value={"basic:model:view"})
    @ResponseBody
    public ResultData childList(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request) {
        List<ModelEntity> list = this.modelBiz.queryChildList(modelEntity);
        return ResultData.build().success(list);
    }

    @Operation(summary="\u83dc\u5355\u5bfc\u5165\u63a5\u53e3")
    @Parameters(value={@Parameter(name="menuStr", description="\u83dc\u5355json", required=true, in=ParameterIn.QUERY), @Parameter(name="modelId", description="\u7236\u7ea7\u83dc\u5355\u7f16\u53f7", required=true, in=ParameterIn.QUERY)})
    @LogAnn(title="\u5bfc\u5165\u83dc\u5355", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/import"})
    @ResponseBody
    @RequiresPermissions(value={"basic:model:save"})
    public ResultData importMenu(String menuStr, int modelId) {
        if (StringUtils.isBlank((CharSequence)menuStr)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("menu")}));
        }
        try {
            List list = JSONUtil.toList((String)menuStr, ModelEntity.class);
            ManagerEntity manager = BasicUtil.getManager();
            assert (manager != null);
            ArrayList<String> modelUrlList = new ArrayList<String>();
            ArrayList<String> modelTitleList = new ArrayList<String>();
            this.addModelUrlAndTitleForList(list, modelUrlList, modelTitleList);
            boolean isRepeat = true;
            if (ObjectUtil.isNotNull((Object)((Object)BasicUtil.getWebsiteApp())) && list.size() == 1) {
                for (ModelEntity modelEntity : list) {
                    isRepeat = !modelEntity.getModelUrl().contains("mdiy/config/data/form.do");
                }
            }
            LambdaQueryWrapper wrapper = null;
            if (CollectionUtil.isNotEmpty(modelTitleList) && isRepeat) {
                wrapper = new LambdaQueryWrapper();
                wrapper.in(ModelEntity::getModelTitle, modelTitleList);
                wrapper.in(ModelEntity::getModelIsMenu, new Object[]{ModelIsMenuEnum.MODEL_MEUN.toInt()});
                List duplicateModelTitles = this.modelBiz.list((Wrapper)wrapper);
                if (CollectionUtil.isNotEmpty((Collection)duplicateModelTitles)) {
                    List collect = duplicateModelTitles.stream().map(ModelEntity::getModelTitle).collect(Collectors.toList());
                    Log.get(ModelAction.class).error("\u4ee5\u4e0b\u6807\u9898\u5df2\u5b58\u5728\uff1a{}", new Object[]{StringUtils.join(collect, (String)",")});
                    return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("model.title")}) + ": " + StringUtils.join(collect, (String)","));
                }
            }
            if (CollectionUtil.isNotEmpty(modelUrlList)) {
                wrapper = new LambdaQueryWrapper();
                wrapper.in(ModelEntity::getModelUrl, modelUrlList);
                List duplicateModelUrls = this.modelBiz.list((Wrapper)wrapper);
                if (CollectionUtil.isNotEmpty((Collection)duplicateModelUrls)) {
                    List collect = duplicateModelUrls.stream().map(ModelEntity::getModelUrl).collect(Collectors.toList());
                    Log.get(ModelAction.class).error("\u4ee5\u4e0b\u6807\u8bc6\u5df2\u5b58\u5728\uff1a{}", new Object[]{StringUtils.join(collect, (String)",")});
                    return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("model.url")}) + ": " + StringUtils.join(collect, (String)","));
                }
            }
            String parentIds = String.valueOf(modelId);
            if (modelId != 0) {
                ModelEntity model = (ModelEntity)((Object)this.modelBiz.getById(Integer.valueOf(modelId)));
                if (model == null) {
                    return ResultData.build().error(this.getResString("err.not.exist", new String[]{this.getResString("model.id")}));
                }
                parentIds = StringUtils.isBlank((CharSequence)model.getModelParentIds()) ? model.getId() : model.getModelParentIds() + "," + model.getId();
            }
            for (ModelEntity modelEntity : list) {
                if (modelEntity.getModelIsMenu() == 0) {
                    return ResultData.build().error("\u529f\u80fd\u6743\u9650\u6309\u94ae\u4e0d\u80fd\u4f5c\u4e3a\u83dc\u5355\u5bfc\u5165!");
                }
                this.modelBiz.importModel(modelEntity, manager.getRoleId(), parentIds, modelId);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return ResultData.build().error(this.getResString("model.title.or.json"));
        }
        catch (Exception e) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("menu")}));
        }
        this.modelBiz.updateCache();
        return ResultData.build().success();
    }

    @Operation(summary="\u83b7\u53d6\u6a21\u5757\u8868")
    @Parameter(name="id", description="\u6a21\u5757\u7684\u7f16\u53f7", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/get"})
    @RequiresPermissions(value={"basic:model:view"})
    @ResponseBody
    public ResultData get(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        if (StringUtils.isEmpty((CharSequence)modelEntity.getId())) {
            return ResultData.build().error(this.getResString("err.error", new String[]{this.getResString("model.id")}));
        }
        ModelEntity _model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)modelEntity.getId())));
        if (_model != null) {
            HashMap<String, ModelEntity> mode = new HashMap<String, ModelEntity>();
            if (_model.getModelId() != null) {
                ModelEntity parentModel = (ModelEntity)((Object)this.modelBiz.getById(_model.getModelId()));
                mode.put("parentModel", parentModel);
            }
            mode.put("model", _model);
            return ResultData.build().success(mode);
        }
        return ResultData.build().success((Object)_model);
    }

    @Operation(summary="\u4fdd\u5b58\u6a21\u5757\u8868\u5b9e\u4f53")
    @Parameters(value={@Parameter(name="modelTitle", description="\u6a21\u5757\u7684\u6807\u9898", required=true, in=ParameterIn.QUERY), @Parameter(name="modelCode", description="\u6a21\u5757\u7f16\u7801", required=false, in=ParameterIn.QUERY), @Parameter(name="modelId", description="\u6a21\u5757\u7236id", required=false, in=ParameterIn.QUERY), @Parameter(name="modelUrl", description="\u94fe\u63a5\u5730\u5740", required=false, in=ParameterIn.QUERY), @Parameter(name="modelIcon", description="\u6a21\u5757\u56fe\u6807", required=false, in=ParameterIn.QUERY), @Parameter(name="modelSort", description="\u6a21\u5757\u6392\u5e8f", required=false, in=ParameterIn.QUERY), @Parameter(name="modelIsMenu", description="\u662f\u5426\u662f\u83dc\u5355,0:\u4e0d\u662f 1:\u662f", required=true, in=ParameterIn.QUERY), @Parameter(name="isChild", description="\u83dc\u5355\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="modelParentIds", description="\u7236\u7ea7\u7f16\u53f7\u96c6\u5408", required=false, in=ParameterIn.QUERY)})
    @LogAnn(title="\u4fdd\u5b58\u6a21\u5757\u8868\u5b9e\u4f53", businessType=BusinessTypeEnum.INSERT)
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"basic:model:save"})
    public ResultData save(@ModelAttribute @Parameter(hidden=true) ModelEntity model, HttpServletResponse response, HttpServletRequest request) {
        ModelEntity _model;
        if (StringUtils.isBlank((CharSequence)model.getModelTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.title")}));
        }
        if (!StringUtil.checkLength(model.getModelTitle(), 1, 10)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.title"), "1", "10"}));
        }
        if (!StringUtil.checkLength(model.getIsChild(), 0, 300)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.is.child"), "0", "300"}));
        }
        if (!StringUtil.checkLength(model.getModelCode(), 0, 255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.code"), "0", "255"}));
        }
        if (!StringUtil.checkLength(model.getModelIcon(), 0, 120)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.icon"), "0", "120"}));
        }
        if (!StringUtil.checkLength(model.getModelParentIds(), 0, 300)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.parent.ids"), "0", "120"}));
        }
        if (!StringUtil.checkLength(model.getModelUrl(), 0, 255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.url"), "0", "255"}));
        }
        if (model.getModelIsMenu().intValue() == ModelIsMenuEnum.MODEL_MEUN.toInt()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(ModelEntity::getModelTitle, (Object)model.getModelTitle())).eq(ModelEntity::getModelIsMenu, (Object)ModelIsMenuEnum.MODEL_MEUN.toInt());
            List list = this.modelBiz.list((Wrapper)wrapper);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("model.title")}));
            }
        }
        if (model.getModelIsMenu().intValue() == ModelIsMenuEnum.MODEL_NOTMENU.toInt()) {
            model.setModelUrl(model.getModelUrl().trim());
            if (StringUtils.isBlank((CharSequence)model.getModelUrl())) {
                return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.url")}));
            }
            List modelList = this.modelBiz.list((Wrapper)new LambdaQueryWrapper().eq(ModelEntity::getModelUrl, (Object)model.getModelUrl()));
            if (CollectionUtil.isNotEmpty((Collection)modelList)) {
                return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("model.url")}));
            }
        }
        model.setModelDatetime(new Timestamp(System.currentTimeMillis()));
        if (!StringUtils.isBlank((CharSequence)model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        if (StringUtils.isNotBlank((CharSequence)model.getModelCode()) && (_model = this.modelBiz.getEntityByModelCode(model.getModelCode())) != null) {
            return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("modelCode")}));
        }
        if (model.getModelSort() == null) {
            model.setModelSort(0);
        }
        if (model.getModelId() != null) {
            ModelEntity modelEntity = (ModelEntity)((Object)this.modelBiz.getById(model.getModelId()));
            if (StringUtils.isBlank((CharSequence)modelEntity.getModelParentIds())) {
                model.setModelParentIds(model.getModelId().toString());
            } else {
                model.setModelParentIds(modelEntity.getModelParentIds() + "," + model.getModelId().toString());
            }
        }
        this.modelBiz.saveModel(model);
        return ResultData.build().success((Object)model.getId());
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u6a21\u5757\u8868")
    @Parameter(name="ids", description="\u6a21\u5757\u7f16\u53f7\uff0c\u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00", required=false, in=ParameterIn.QUERY)
    @LogAnn(title="\u6279\u91cf\u5220\u9664\u6a21\u5757\u8868", businessType=BusinessTypeEnum.DELETE)
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"basic:model:del"})
    public ResultData delete(@RequestBody List<ModelEntity> modelEntityList, HttpServletResponse response, HttpServletRequest request) {
        if (CollUtil.isEmpty(modelEntityList)) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("id")}));
        }
        this.modelBiz.delete(modelEntityList);
        return ResultData.build().success();
    }

    @Operation(summary="\u66f4\u65b0\u6a21\u5757\u8868\u4fe1\u606f\u6a21\u5757\u8868")
    @Parameters(value={@Parameter(name="id", description="\u6a21\u5757\u7684\u7f16\u53f7", required=true, in=ParameterIn.QUERY), @Parameter(name="modelTitle", description="\u6a21\u5757\u7684\u6807\u9898", required=true, in=ParameterIn.QUERY), @Parameter(name="modelCode", description="\u6a21\u5757\u7f16\u7801", required=false, in=ParameterIn.QUERY), @Parameter(name="modelId", description="\u6a21\u5757\u7236id", required=false, in=ParameterIn.QUERY), @Parameter(name="modelUrl", description="\u94fe\u63a5\u5730\u5740", required=false, in=ParameterIn.QUERY), @Parameter(name="modelIcon", description="\u6a21\u5757\u56fe\u6807", required=false, in=ParameterIn.QUERY), @Parameter(name="modelSort", description="\u6a21\u5757\u6392\u5e8f", required=false, in=ParameterIn.QUERY), @Parameter(name="isChild", description="\u83dc\u5355\u7c7b\u578b", required=false, in=ParameterIn.QUERY), @Parameter(name="modelParentIds", description="\u7236\u7ea7\u7f16\u53f7\u96c6\u5408", required=false, in=ParameterIn.QUERY)})
    @LogAnn(title="\u66f4\u65b0\u6a21\u5757\u8868\u4fe1\u606f\u6a21\u5757\u8868", businessType=BusinessTypeEnum.UPDATE)
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"basic:model:update"})
    @ResponseBody
    public ResultData update(@ModelAttribute @Parameter(hidden=true) ModelEntity model, HttpServletResponse response, HttpServletRequest request) {
        ModelEntity _model;
        if (StringUtils.isBlank((CharSequence)model.getModelTitle())) {
            return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.title")}));
        }
        if (!StringUtil.checkLength(model.getModelTitle(), 1, 10)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.title"), "1", "10"}));
        }
        if (!StringUtil.checkLength(model.getIsChild(), 0, 300)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.is.child"), "0", "300"}));
        }
        if (!StringUtil.checkLength(model.getModelCode(), 0, 255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.code"), "0", "255"}));
        }
        if (!StringUtil.checkLength(model.getModelIcon(), 0, 120)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.icon"), "0", "120"}));
        }
        if (!StringUtil.checkLength(model.getModelUrl(), 0, 255)) {
            return ResultData.build().error(this.getResString("err.length", new String[]{this.getResString("model.url"), "0", "255"}));
        }
        if (model.getModelIsMenu().intValue() == ModelIsMenuEnum.MODEL_MEUN.toInt()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)wrapper.eq(ModelEntity::getModelTitle, (Object)model.getModelTitle())).eq(ModelEntity::getModelIsMenu, (Object)ModelIsMenuEnum.MODEL_MEUN.toInt());
            List list = this.modelBiz.list((Wrapper)wrapper);
            if (CollectionUtil.isNotEmpty((Collection)list) && (list.size() > 1 || !((ModelEntity)((Object)list.get(0))).getId().equals(model.getId()))) {
                return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("model.title")}));
            }
        }
        if ((_model = (ModelEntity)((Object)this.modelBiz.getById((Serializable)((Object)model.getId())))).getModelIsMenu() == 1 && model.getModelIsMenu() == 0) {
            return ResultData.build().error(this.getResString("model.is.menu"));
        }
        if (model.getModelIsMenu().intValue() == ModelIsMenuEnum.MODEL_NOTMENU.toInt()) {
            model.setModelUrl(model.getModelUrl().trim());
            if (StringUtils.isBlank((CharSequence)model.getModelUrl())) {
                return ResultData.build().error(this.getResString("err.empty", new String[]{this.getResString("model.url")}));
            }
            List modelList = this.modelBiz.list((Wrapper)new LambdaQueryWrapper().eq(ModelEntity::getModelUrl, (Object)model.getModelUrl()));
            if (CollectionUtil.isNotEmpty((Collection)modelList) && !((ModelEntity)((Object)modelList.get(0))).getId().equals(model.getId())) {
                return ResultData.build().error(this.getResString("err.exist", new String[]{this.getResString("model.url")}));
            }
        }
        if (!StringUtils.isBlank((CharSequence)model.getModelIcon())) {
            model.setModelIcon(model.getModelIcon().replace("|", ""));
        }
        if (StringUtils.isBlank((CharSequence)_model.getAppId())) {
            model.setAppId(null);
        } else {
            model.setAppId(_model.getAppId());
        }
        this.modelBiz.updateEntity(model);
        return ResultData.build().success((Object)model.getId());
    }

    @Operation(summary="\u6839\u636e\u7ba1\u7406\u5458ID\u67e5\u8be2\u6a21\u5757\u96c6\u5408")
    @Parameter(name="managerId", description="\u7ba1\u7406\u5458id", required=true, in=ParameterIn.PATH)
    @GetMapping(value={"/{managerId}/queryModelByRoleId"})
    @ResponseBody
    public ResultData queryModelByRoleId(@PathVariable @Parameter(hidden=true) int managerId, HttpServletRequest request, HttpServletResponse response) {
        ManagerEntity manager = (ManagerEntity)this.managerBiz.getEntity(managerId);
        if (manager == null) {
            return ResultData.build().error();
        }
        HashSet<ModelEntity> modelSet = new HashSet<ModelEntity>();
        for (String roleId : manager.getRoleIds().split(",")) {
            modelSet.addAll(this.modelBiz.queryModelByRoleId(Integer.parseInt(roleId)));
        }
        ArrayList modelList = new ArrayList(modelSet);
        return ResultData.build().success(modelList);
    }

    @Operation(summary="\u67e5\u8be2\u6a21\u5757\u8868\u5217\u8868")
    @Parameter(name="roleId", description="\u89d2\u8272\u7f16\u53f7", required=true, in=ParameterIn.QUERY)
    @GetMapping(value={"/modelList"})
    @ResponseBody
    public ResultData modelList(@ModelAttribute @Parameter(hidden=true) ModelEntity modelEntity, HttpServletResponse response, HttpServletRequest request, @Parameter(hidden=true) ModelMap model) {
        int roleId = BasicUtil.getInt("roleId");
        ManagerEntity managerSession = BasicUtil.getManager();
        boolean updateFlag = roleId != 0;
        List<ModelEntity> modelList = this.modelStrategy.list();
        ArrayList<ModelEntity> _modelList = new ArrayList<ModelEntity>();
        List<Object> roleModelList = new ArrayList();
        if (roleId > 0) {
            roleModelList = this.roleModelBiz.queryByRoleId(roleId);
        } else {
            HashSet<RoleModelEntity> roleSet = new HashSet<RoleModelEntity>();
            for (String id : managerSession.getRoleIds().split(",")) {
                roleSet.addAll(this.roleModelBiz.queryByRoleId(Integer.parseInt(id)));
            }
            roleModelList.addAll(roleSet);
        }
        ArrayList<ModelEntity> childModelList = new ArrayList<ModelEntity>();
        for (BaseEntity baseEntity : modelList) {
            ModelEntity _model = (ModelEntity)baseEntity;
            if (_model.getModelIsMenu() == 1) {
                _model.setModelChildList(new ArrayList<ModelEntity>());
                _modelList.add(_model);
                continue;
            }
            if (_model.getModelIsMenu() != 0) continue;
            childModelList.add(_model);
        }
        for (ModelEntity modelEntity2 : _modelList) {
            for (ModelEntity childModel : childModelList) {
                if (childModel.getModelId() != Integer.parseInt(modelEntity2.getId())) continue;
                modelEntity2.getModelChildList().add(childModel);
                for (RoleModelEntity roleModelEntity : roleModelList) {
                    if (roleModelEntity.getModelId() != Integer.parseInt(childModel.getId()) || !updateFlag) continue;
                    childModel.setChick(1);
                }
            }
        }
        EUListBean _list = new EUListBean(_modelList, _modelList.size());
        return ResultData.build().success((Object)_list);
    }

    private void addModelUrlAndTitleForList(List<ModelEntity> modelEntityList, List<String> modelUrlList, List<String> modelTitleList) {
        if (CollectionUtil.isEmpty(modelEntityList) || modelUrlList == null || modelTitleList == null) {
            return;
        }
        for (ModelEntity model : modelEntityList) {
            if (!StringUtil.checkLength(model.getModelTitle(), 1, 20)) {
                throw new BusinessException(this.getResString("err.length", new String[]{this.getResString("model.title"), "1", "20"}));
            }
            if (model.getModelIsMenu().intValue() == ModelIsMenuEnum.MODEL_NOTMENU.toInt()) {
                if (StringUtils.isBlank((CharSequence)model.getModelUrl())) {
                    throw new BusinessException(this.getResString("err.empty", new String[]{this.getResString("model.url")}));
                }
                model.setModelUrl(model.getModelUrl().trim());
                modelUrlList.add(model.getModelUrl());
            } else {
                modelTitleList.add(model.getModelTitle());
            }
            if (!CollectionUtil.isNotEmpty(model.getModelChildList())) continue;
            this.addModelUrlAndTitleForList(model.getModelChildList(), modelUrlList, modelTitleList);
        }
    }
}

