/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.service;

import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mingsoft.basic.util.ConfigUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class CacheConfigService {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public void load() {
        String sql = "SELECT ID,MODEL_ID,CONFIG_NAME,CONFIG_DATA,CONFIG_TYPE,APP_ID FROM MDIY_CONFIG WHERE CONFIG_TYPE = ? AND DEL = 0";
        List configList = this.jdbcTemplate.queryForList(sql, new Object[]{"config"});
        List<Map> camelCaseConfigList = configList.stream().map(configMap -> MapUtil.toCamelCaseMap((Map)new CaseInsensitiveMap(configMap))).collect(Collectors.toList());
        HashMap<String, Map<String, Map<String, Object>>> allConfig = new HashMap<String, Map<String, Map<String, Object>>>();
        camelCaseConfigList.forEach(config -> {
            String appId = config.get("appId").toString();
            String configName = config.get("configName").toString();
            allConfig.computeIfAbsent(appId, k -> new HashMap()).computeIfAbsent(configName, k -> new HashMap()).putAll(config);
        });
        ConfigUtil.init(allConfig);
    }
}

