/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action.web;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.action.BaseAction;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.ICategoryBiz;
import net.mingsoft.basic.entity.CategoryEntity;
import net.mingsoft.basic.util.BasicUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u4f9b\u524d\u7aef\u67e5\u8be2\u5206\u7c7b\u4fe1\u606f\u4f7f\u7528\u63a5\u53e3")
@Controller(value="webCategory")
@RequestMapping(value={"/category"})
public class CategoryAction
extends BaseAction {
    @Autowired
    private ICategoryBiz categoryBiz;

    @ApiOperation(value="\u6839\u636e\u5206\u7c7bid\u67e5\u627e\u5176\u7236\u5206\u7c7b,\u5982\u679c\u7236\u5206\u7c7b\u4e0d\u5b58\u5728\u5219\u8fd4\u56de\u8be5\u5206\u7c7b")
    @ApiImplicitParam(name="categoryId", value="\u5206\u7c7b\u7f16\u53f7", required=true, paramType="path")
    @GetMapping(value={"/{categoryId}/getParentCategory"})
    @ResponseBody
    public void getParentCategory(@PathVariable @ApiIgnore int categoryId, HttpServletRequest request, HttpServletResponse response) {
        CategoryEntity category = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        if (ObjectUtil.isNotNull((Object)((Object)category))) {
            CategoryEntity paCategory = (CategoryEntity)this.categoryBiz.getEntity(category.getCategoryCategoryId());
            if (ObjectUtil.isNull((Object)((Object)paCategory))) {
                this.outJson(response, JSONObject.toJSONString((Object)((Object)category)));
            } else {
                this.outJson(response, JSONObject.toJSONString((Object)((Object)paCategory)));
            }
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u5206\u7c7bid\u67e5\u8be2\u5176\u5b50\u5206\u7c7b")
    @ApiImplicitParam(name="categoryId", value="\u5206\u7c7b\u7f16\u53f7", required=true, paramType="path")
    @GetMapping(value={"/{categoryId}/queryChildren"})
    public void queryChildren(@PathVariable @ApiIgnore int categoryId, HttpServletRequest request, HttpServletResponse response) {
        CategoryEntity category = (CategoryEntity)this.categoryBiz.getEntity(categoryId);
        if (category != null) {
            List<CategoryEntity> list = this.categoryBiz.queryChilds(category);
            this.outJson(response, JSONObject.toJSONStringWithDateFormat(list, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]));
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u5206\u7c7bid\u67e5\u8be2\u5176\u5b50\u5206\u7c7b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="categoryModelId", value="\u6240\u5c5e\u6a21\u5757\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="categoryDateTime", value="\u7c7b\u522b\u53d1\u5e03\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="categoryManagerId", value="\u53d1\u5e03\u7528\u6237\u7f16\u53f7(\u53d1\u5e03\u8005\u7f16\u53f7)", required=false, paramType="query"), @ApiImplicitParam(name="categoryCategoryId", value="\u7236\u7c7b\u522b\u7684\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryDictId", value="\u5b57\u5178\u5bf9\u5e94\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="categoryTitle", value="\u7c7b\u522b\u7684\u6807\u9898", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore CategoryEntity category, HttpServletResponse response, HttpServletRequest request, ModelMap model) {
        if (category.getCategoryModelId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("category.modelid")}));
            return;
        }
        category.setCategoryAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List categoryList = this.categoryBiz.query(category);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(categoryList, (int)BasicUtil.endPage(categoryList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }
}

