/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.Feature;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportParser {
    private static final Logger LOG = LogManager.getLogger(ReportParser.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final Configuration configuration;

    public ReportParser(Configuration configuration) {
        this.configuration = configuration;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        InjectableValues.Std values = new InjectableValues.Std().addValue(Configuration.class, (Object)configuration);
        this.mapper.setInjectableValues((InjectableValues)values);
    }

    public List<Feature> parseJsonFiles(List<String> jsonFiles) {
        ArrayList<Feature> featureResults = new ArrayList<Feature>();
        for (int i = 0; i < jsonFiles.size(); ++i) {
            String jsonFile = jsonFiles.get(i);
            Object[] features = this.parseForFeature(jsonFile);
            if (ArrayUtils.isEmpty((Object[])features)) {
                LOG.info("File '{}' does not contain features", (Object)jsonFile);
                continue;
            }
            LOG.info("File '{}' contain {} features", (Object)jsonFile, (Object)features.length);
            this.setMetadata((Feature[])features, jsonFile, i);
            featureResults.addAll(Arrays.asList(features));
        }
        return featureResults;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Feature[] parseForFeature(String jsonFile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);){
            Feature[] featureArray = (Feature[])this.mapper.readValue((Reader)reader, Feature[].class);
            return featureArray;
        }
        catch (JsonMappingException e) {
            LOG.info("File '{}' is not proper Cucumber-JVM report", (Object)jsonFile, (Object)e);
            return new Feature[0];
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private void setMetadata(Feature[] features, String jsonFile, int jsonFileNo) {
        for (Feature feature : features) {
            feature.setMetaData(jsonFile, jsonFileNo, this.configuration);
        }
    }
}

