/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import org.codehaus.plexus.util.Base64;

public class Embedded {
    private final String mime_type;
    private final String data;
    private static int counter = 0;

    public Embedded() {
        this.mime_type = null;
        this.data = null;
    }

    public String render(int index) {
        String uniqueContentId = this.generateNextUniqueId();
        switch (this.mime_type) {
            case "image/png": {
                return this.publishImg("png", uniqueContentId, index);
            }
            case "image/bmp": {
                return this.publishImg("bmp", uniqueContentId, index);
            }
            case "text/plain": {
                return this.publishPlainType(uniqueContentId, index);
            }
            case "text/html": {
                return this.publishHTMLType(uniqueContentId, index);
            }
        }
        return this.publishUnknownType(this.mime_type, index);
    }

    private static String getImg(String imageId, String encodedImageContent) {
        return String.format("<img id=\"%s\" src=\"%s\" style=\"max-width:250px; display:none;\"/>", imageId, encodedImageContent);
    }

    private String publishImg(String imgType, String imageId, int index) {
        String encodedImageContent = "data:image/" + imgType + ";base64," + this.data;
        StringBuilder sb = new StringBuilder();
        sb.append(Embedded.getExpandAnchor(imageId, "Screenshot", index));
        sb.append(String.format("<a href=\"%s\">", encodedImageContent));
        sb.append(Embedded.getImg(imageId, encodedImageContent));
        sb.append("</a></br>");
        return sb.toString();
    }

    private String publishPlainType(String contentId, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(Embedded.getExpandAnchor(contentId, "Plain text", index));
        sb.append(String.format("<pre id=\"%s\" style=\"max-width:250px; display:none;\">%s</pre><br>", contentId, this.decodeDataFromBase()));
        return sb.toString();
    }

    private String publishHTMLType(String contentId, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(Embedded.getExpandAnchor(contentId, "HTML text", index));
        sb.append(String.format("<span id=\"%s\" style=\"max-width:250px; display:none;\">%s</span><br>", contentId, this.decodeDataFromBase()));
        return sb.toString();
    }

    private String publishUnknownType(String mimeType, int index) {
        return String.format("<span style=\"color:red\">Attachment number %d, has unsupported mimetype '%s'.<br>File the bug <a href=\"https://github.com/damianszczepanik/cucumber-reporting/issues\">here</a> so support will be added!</span>", index, mimeType);
    }

    private static String getExpandAnchor(String contentId, String label, int index) {
        return String.format("<a onclick=\"attachment=document.getElementById('%s'); attachment.style.display = (attachment.style.display == 'none' ? 'block' : 'none');return false\">%s %d</a>", contentId, label, index + 1);
    }

    private String decodeDataFromBase() {
        return new String(Base64.decodeBase64((byte[])this.data.getBytes()));
    }

    private String generateNextUniqueId() {
        return "embedding-" + ++counter;
    }
}

