/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent.mdc;

import java.util.regex.Pattern;
import net.logstash.logback.composite.loggingevent.mdc.MdcEntryWriter;
import tools.jackson.core.JsonGenerator;

public class DoubleMdcEntryWriter
implements MdcEntryWriter {
    private static final Pattern DOUBLE_PATTERN = DoubleMdcEntryWriter.doublePattern();

    @Override
    public boolean writeMdcEntry(JsonGenerator generator, String fieldName, String mdcKey, String mdcValue) {
        if (this.shouldParse(mdcValue)) {
            try {
                double parsedValue = Double.parseDouble(mdcValue);
                generator.writeNumberProperty(fieldName, parsedValue);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean shouldParse(String value) {
        return value != null && !value.isEmpty() && DOUBLE_PATTERN.matcher(value).matches();
    }

    private static Pattern doublePattern() {
        String Digits = "(\\p{Digit}+)";
        String HexDigits = "(\\p{XDigit}+)";
        String Exp = "[eE][+-]?(\\p{Digit}+)";
        String fpRegex = "[\\x00-\\x20]*[+-]?(((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        return Pattern.compile("[\\x00-\\x20]*[+-]?(((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
    }
}

