/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.licenser.spotless.internal;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.spotless.ThrowingEx;
import groovy.text.SimpleTemplateEngine;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.kyori.indra.licenser.spotless.HeaderFormat;
import net.kyori.indra.licenser.spotless.HeaderFormatApplier;
import net.kyori.indra.licenser.spotless.IndraSpotlessLicenserExtension;
import net.kyori.indra.licenser.spotless.internal.HeaderFormatApplierImpl;
import net.kyori.mammoth.Properties;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;
import org.jetbrains.annotations.NotNull;

public class IndraSpotlessLicenserExtensionImpl
implements IndraSpotlessLicenserExtension {
    private static final Pattern LINE_SPLIT = Pattern.compile("\r?\n");
    private final ObjectFactory objects;
    private final TextResourceFactory textResources;
    private final Property<TextResource> licenseHeaderFile;
    private final Property<HeaderFormat> headerFormat;
    private final MapProperty<String, HeaderFormat> languageFormatOverrides;
    private final MapProperty<String, Object> properties;
    private final Property<Boolean> newLine;
    private final List<Action<FormatExtension.LicenseHeaderConfig>> extraConfigureSteps;

    @Inject
    public IndraSpotlessLicenserExtensionImpl(ObjectFactory objects, TextResourceFactory textResources) {
        this.objects = objects;
        this.textResources = textResources;
        this.licenseHeaderFile = objects.property(TextResource.class);
        this.headerFormat = objects.property(HeaderFormat.class).convention((Object)HeaderFormat.starSlash());
        this.languageFormatOverrides = objects.mapProperty(String.class, HeaderFormat.class);
        this.properties = objects.mapProperty(String.class, Object.class);
        this.newLine = objects.property(Boolean.class).convention((Object)false);
        this.extraConfigureSteps = new ArrayList<Action<FormatExtension.LicenseHeaderConfig>>();
    }

    @Override
    @NotNull
    public Property<TextResource> licenseHeaderFile() {
        return this.licenseHeaderFile;
    }

    @Override
    public void licenseHeaderFile(@NotNull Object file) {
        this.licenseHeaderFile.set((Object)this.textResources.fromFile(file, "UTF-8"));
    }

    @Override
    @NotNull
    public Property<HeaderFormat> headerFormat() {
        return this.headerFormat;
    }

    @Override
    @NotNull
    public MapProperty<String, HeaderFormat> languageFormatOverrides() {
        return this.languageFormatOverrides;
    }

    @Override
    public void languageFormatOverride(@NotNull String language, @NotNull HeaderFormat headerFormat) {
        this.languageFormatOverrides.put((Object)language, (Object)headerFormat);
    }

    @Override
    public void languageFormatOverride(@NotNull String language, @NotNull Action<HeaderFormatApplier> configurer) {
        Property headerFormat = this.objects.property(HeaderFormat.class);
        this.languageFormatOverrides.put((Object)language, (Provider)headerFormat);
        Objects.requireNonNull(configurer, "configurer").execute((Object)new HeaderFormatApplierImpl((Property<HeaderFormat>)headerFormat));
    }

    @Override
    @NotNull
    public MapProperty<String, Object> properties() {
        return this.properties;
    }

    @Override
    @NotNull
    public Property<Boolean> newLine() {
        return this.newLine;
    }

    @Override
    public void extraConfig(@NotNull Action<FormatExtension.LicenseHeaderConfig> configureStep) {
        this.extraConfigureSteps.add(Objects.requireNonNull(configureStep, "configureStep"));
    }

    public List<Action<FormatExtension.LicenseHeaderConfig>> extraConfigSteps() {
        return Collections.unmodifiableList(this.extraConfigureSteps);
    }

    public ThrowingEx.Supplier<String> createHeaderSupplier(String name) {
        return () -> {
            String licenseHeader;
            File licenseHeaderFile = ((TextResource)this.licenseHeaderFile().get()).asFile("UTF-8");
            try (BufferedReader reader = Files.newBufferedReader(licenseHeaderFile.toPath(), StandardCharsets.UTF_8);){
                Map properties = (Map)((MapProperty)Properties.finalized(this.properties())).get();
                if (!properties.isEmpty()) {
                    HashMap<String, String> templateParams = new HashMap<String, String>(properties);
                    templateParams.putIfAbsent("YEAR", "$YEAR");
                    licenseHeader = new SimpleTemplateEngine().createTemplate((Reader)reader).make(templateParams).toString();
                } else {
                    licenseHeader = new String(Files.readAllBytes(licenseHeaderFile.toPath()), StandardCharsets.UTF_8);
                }
            }
            HeaderFormat format = ((Map)((MapProperty)Properties.finalized(this.languageFormatOverrides)).get()).getOrDefault(name, (HeaderFormat)((Property)Properties.finalized(this.headerFormat())).get());
            return IndraSpotlessLicenserExtensionImpl.formatHeader(licenseHeader, format, true, (Boolean)((Property)Properties.finalized(this.newLine())).get());
        };
    }

    private static String formatHeader(String header, HeaderFormat format, boolean trimBody, boolean newLine) {
        String prefix;
        String lineSeparator = System.lineSeparator();
        String string = prefix = format.begin() != null ? format.begin() + lineSeparator : "";
        String suffix = format.end() != null ? (newLine ? lineSeparator + format.end() + lineSeparator + lineSeparator : lineSeparator + format.end() + lineSeparator) : "";
        return LINE_SPLIT.splitAsStream(header).map(line -> {
            if (format.linePrefix() != null || format.lineSuffix() != null) {
                StringBuilder builder = new StringBuilder(line.length() + 4);
                if (format.linePrefix() != null) {
                    builder.append(format.linePrefix());
                }
                builder.append((String)line);
                if (format.lineSuffix() != null) {
                    builder.append(format.lineSuffix());
                }
                return trimBody ? IndraSpotlessLicenserExtensionImpl.trimEnd(builder.toString()) : builder.toString();
            }
            return line;
        }).collect(Collectors.joining(lineSeparator, prefix, suffix));
    }

    private static String trimEnd(String input) {
        int i;
        for (i = input.length() - 1; i >= 0 && Character.isWhitespace(input.charAt(i)); --i) {
        }
        return input.substring(0, i + 1);
    }
}

