/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.event;

import java.net.URL;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.util.Index;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.Examiner;
import net.kyori.examination.string.StringExaminer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ClickEvent
implements Examinable,
StyleBuilderApplicable {
    private final Action action;
    private final String value;

    public static @NonNull ClickEvent openUrl(@NonNull String url) {
        return new ClickEvent(Action.OPEN_URL, url);
    }

    public static @NonNull ClickEvent openUrl(@NonNull URL url) {
        return ClickEvent.openUrl(url.toExternalForm());
    }

    public static @NonNull ClickEvent openFile(@NonNull String file) {
        return new ClickEvent(Action.OPEN_FILE, file);
    }

    public static @NonNull ClickEvent runCommand(@NonNull String command) {
        return new ClickEvent(Action.RUN_COMMAND, command);
    }

    public static @NonNull ClickEvent suggestCommand(@NonNull String command) {
        return new ClickEvent(Action.SUGGEST_COMMAND, command);
    }

    public static @NonNull ClickEvent changePage(@NonNull String page) {
        return new ClickEvent(Action.CHANGE_PAGE, page);
    }

    public static @NonNull ClickEvent changePage(int page) {
        return ClickEvent.changePage(String.valueOf(page));
    }

    public static @NonNull ClickEvent copyToClipboard(@NonNull String text) {
        return new ClickEvent(Action.COPY_TO_CLIPBOARD, text);
    }

    public static @NonNull ClickEvent clickEvent(@NonNull Action action, @NonNull String value) {
        return new ClickEvent(action, value);
    }

    private ClickEvent(@NonNull Action action, @NonNull String value) {
        this.action = Objects.requireNonNull(action, "action");
        this.value = Objects.requireNonNull(value, "value");
    }

    public @NonNull Action action() {
        return this.action;
    }

    public @NonNull String value() {
        return this.value;
    }

    @Override
    public void styleApply( @NonNull Style.Builder style) {
        style.clickEvent(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClickEvent that = (ClickEvent)other;
        return this.action == that.action && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = this.action.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of((String)"action", (Object)((Object)this.action)), ExaminableProperty.of((String)"value", (String)this.value));
    }

    public String toString() {
        return (String)this.examine((Examiner)StringExaminer.simpleEscaping());
    }

    public static enum Action {
        OPEN_URL("open_url", true),
        OPEN_FILE("open_file", false),
        RUN_COMMAND("run_command", true),
        SUGGEST_COMMAND("suggest_command", true),
        CHANGE_PAGE("change_page", true),
        COPY_TO_CLIPBOARD("copy_to_clipboard", true);

        public static final Index<String, Action> NAMES;
        private final String name;
        private final boolean readable;

        private Action(String name, boolean readable) {
            this.name = name;
            this.readable = readable;
        }

        public boolean readable() {
            return this.readable;
        }

        public @NonNull String toString() {
            return this.name;
        }

        static {
            NAMES = Index.create(Action.class, constant -> constant.name);
        }
    }
}

